/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.FilterEventsWriterStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;

public class Main {
    public static void main(String[] args) throws URISyntaxException, UnsupportedEncodingException {
        PipelineDriver driver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        driver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        URL inputXml = Main.class.getResource("test.xml");
        InputStream in = Main.class.getResourceAsStream("identity.xsl");
        driver.addStep((IPipelineStep)new XsltTransformStep(in));
        in = Main.class.getResourceAsStream("remove_b_tags.xsl");
        driver.addStep((IPipelineStep)new XsltTransformStep(in));
        driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        driver.addStep((IPipelineStep)new FilterEventsWriterStep());
        RawDocument rawDoc = new RawDocument(inputXml.toURI(), "UTF-8", new LocaleId("en"), new LocaleId("fr"));
        rawDoc.setFilterConfigId("okf_xml");
        driver.addBatchItem(rawDoc, new File("output.xml").toURI(), "UTF-8");
        driver.processBatch();
    }
}

