/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import org.eclipse.swt.widgets.Text;

public class Utils {
    public static String escapeToRTF(String p_sText, boolean p_bConvertLineBreaks, int p_nLineBreakStyle, Charset p_Enc) {
        if (p_sText == null) {
            return "";
        }
        StringBuffer sbTmp = new StringBuffer(p_sText.length());
        block22: for (int i = 0; i < p_sText.length(); ++i) {
            switch (p_sText.charAt(i)) {
                case '\\': 
                case '{': 
                case '}': {
                    sbTmp.append('\\');
                    sbTmp.append(p_sText.charAt(i));
                    continue block22;
                }
                case '\r': {
                    continue block22;
                }
                case '\n': {
                    if (p_bConvertLineBreaks) {
                        switch (p_nLineBreakStyle) {
                            case 1: {
                                sbTmp.append("}");
                                sbTmp.append("\r\n\\par ");
                                sbTmp.append("{\\cs5\\f1\\cf15\\lang1024 ");
                                continue block22;
                            }
                            case 2: {
                                sbTmp.append("}");
                                sbTmp.append("\r\n\\par ");
                                sbTmp.append("{\\cs6\\f1\\cf6\\lang1024 ");
                                continue block22;
                            }
                        }
                        sbTmp.append("\r\n\\par ");
                        continue block22;
                    }
                    sbTmp.append(p_sText.charAt(i));
                    continue block22;
                }
                case '\u00a0': {
                    sbTmp.append("\\~");
                    continue block22;
                }
                case '\t': {
                    sbTmp.append("\\tab ");
                    continue block22;
                }
                case '\u2022': {
                    sbTmp.append("\\bullet ");
                    continue block22;
                }
                case '\u2018': {
                    sbTmp.append("\\lquote ");
                    continue block22;
                }
                case '\u2019': {
                    sbTmp.append("\\rquote ");
                    continue block22;
                }
                case '\u201c': {
                    sbTmp.append("\\ldblquote ");
                    continue block22;
                }
                case '\u201d': {
                    sbTmp.append("\\rdblquote ");
                    continue block22;
                }
                case '\u2013': {
                    sbTmp.append("\\endash ");
                    continue block22;
                }
                case '\u2014': {
                    sbTmp.append("\\emdash ");
                    continue block22;
                }
                case '\u200d': {
                    sbTmp.append("\\zwj ");
                    continue block22;
                }
                case '\u200c': {
                    sbTmp.append("\\zwnj ");
                    continue block22;
                }
                case '\u200e': {
                    sbTmp.append("\\ltrmark ");
                    continue block22;
                }
                case '\u200f': {
                    sbTmp.append("\\rtlmark ");
                    continue block22;
                }
                default: {
                    if (p_sText.codePointAt(i) > 127) {
                        ByteBuffer bBuf = p_Enc.encode(Integer.toString(p_sText.codePointAt(i)));
                        if (bBuf.limit() > 1) {
                            sbTmp.append(String.format("{{\\uc%1$d", bBuf.limit()));
                            sbTmp.append(String.format("\\u%1$d", p_sText.codePointAt(i)));
                            for (int b = 0; b < bBuf.limit(); ++b) {
                                sbTmp.append(String.format("\\'%1$x", Character.valueOf(bBuf.getChar(b))));
                            }
                            sbTmp.append("}");
                            continue block22;
                        }
                        sbTmp.append(String.format("\\u%1$d", p_sText.codePointAt(i)));
                        sbTmp.append(String.format("\\'%1$x", Character.valueOf(bBuf.getChar(0))));
                        continue block22;
                    }
                    sbTmp.append(p_sText.charAt(i));
                }
            }
        }
        return sbTmp.toString();
    }

    public static int getPercentage(long p_nPart, long p_nTotal) {
        return (int)((float)p_nPart / (float)(p_nTotal == 0L ? 1L : p_nTotal) * 100.0f);
    }

    public static String getANSIEncoding(String p_sLanguage) {
        String sEncoding = "windows-1252";
        return sEncoding;
    }

    public static LocaleId getDefaultSourceLanguage() {
        return LocaleId.fromString("en-us");
    }

    public static LocaleId getDefaultTargetLanguage() {
        LocaleId lang = new LocaleId(Locale.getDefault());
        if (lang.sameLanguageAs(Utils.getDefaultSourceLanguage())) {
            lang = LocaleId.fromString("fr-fr");
        }
        return lang;
    }

    public static String getCurrentLanguage() {
        String tmp1 = Locale.getDefault().getLanguage();
        String tmp2 = Locale.getDefault().getCountry();
        return tmp1 + (tmp2.length() == 0 ? "" : "-" + tmp2);
    }

    public static String getOkapiSharedFolder(String rootFolder, boolean fromJar) {
        if (fromJar) {
            return rootFolder + File.separatorChar + "lib" + File.separator + "shared";
        }
        return rootFolder + File.separatorChar + "classes" + File.separator + "shared";
    }

    public static String removeExtension(String p_sPath) {
        int n1 = p_sPath.lastIndexOf(File.separator);
        int n2 = p_sPath.lastIndexOf(46);
        if (n2 > -1 && n1 < n2) {
            return p_sPath.substring(0, n2);
        }
        return p_sPath;
    }

    public static String detectEncoding(String p_sPath) {
        FileInputStream IS = null;
        String encoding = null;
        try {
            IS = new FileInputStream(p_sPath);
            byte[] Buf = new byte[9];
            int nRead = IS.read(Buf, 0, 3);
            if (nRead > 1) {
                if (Buf[0] == -2 && Buf[1] == -1) {
                    encoding = "UTF-16BE";
                }
                if (Buf[0] == -1 && Buf[1] == -2) {
                    encoding = "UTF-16LE";
                }
                if (nRead > 2 && Buf[0] == -17 && Buf[1] == -69 && Buf[3] == -65) {
                    encoding = "UTF-8";
                }
            }
        }
        catch (IOException e) {
            throw new OkapiException(e);
        }
        finally {
            if (IS != null) {
                try {
                    IS.close();
                }
                catch (IOException e) {}
            }
        }
        return encoding;
    }

    public static char checksCharList(String p_sText, String p_sCharList) {
        if (p_sCharList == null || p_sCharList.length() == 0) {
            return '\u0000';
        }
        if (p_sText == null || p_sText.length() == 0) {
            return '\u0000';
        }
        for (int i = 0; i < p_sCharList.length(); ++i) {
            if (p_sText.indexOf(p_sCharList.charAt(i)) == -1) continue;
            return p_sCharList.charAt(i);
        }
        return '\u0000';
    }

    public static void checkProjectDirAfterPick(String path, Text edField, String projectDir) {
        if (path == null) {
            return;
        }
        String oriPath = edField.getText().replace("${ProjDir}", projectDir);
        if (!path.equals(oriPath)) {
            edField.setText(path);
        }
        edField.selectAll();
        edField.setFocus();
    }
}

