/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.logger;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.sf.okapi.applications.rainbow.lib.ILog;
import net.sf.okapi.applications.rainbow.logger.ILogHandler;

class LogHandlerJDK
extends Handler
implements ILogHandler {
    private ILog log;

    protected LogHandlerJDK() {
    }

    @Override
    public void initialize(ILog log) {
        if (log == null) {
            return;
        }
        this.log = log;
        this.setLevel(Level.INFO);
        Logger.getLogger("").addHandler(this);
    }

    @Override
    public void setLogLevel(int level) {
        switch (level) {
            case 2: {
                this.setLevel(Level.FINE);
                Logger.getLogger("").setLevel(Level.FINE);
                break;
            }
            case 1: {
                this.setLevel(Level.FINEST);
                Logger.getLogger("").setLevel(Level.FINEST);
                break;
            }
            default: {
                this.setLevel(Level.INFO);
                Logger.getLogger("").setLevel(Level.INFO);
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        if (this.log == null) {
            return;
        }
        Level lev = record.getLevel();
        if (lev == Level.SEVERE) {
            this.log.error(record.getMessage());
            Throwable e = record.getThrown();
            if (e != null) {
                this.log.message(" @ " + e.toString());
            }
        } else if (lev == Level.WARNING) {
            if ("org.apache.axis.utils.JavaUtils".equals(record.getLoggerName())) {
                return;
            }
            this.log.warning(record.getMessage());
        } else {
            this.log.message(record.getMessage());
        }
    }
}

