/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtils {
    private IOUtils() {
    }

    public static <E extends Exception> void closeSafely(E priorException, Closeable ... objects) throws E, IOException {
        Throwable th = null;
        for (Closeable object : objects) {
            try {
                if (object == null) continue;
                object.close();
            }
            catch (Throwable t) {
                if (th != null) continue;
                th = t;
            }
        }
        if (priorException != null) {
            throw priorException;
        }
        if (th != null) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    public static <E extends Exception> void closeSafely(E priorException, Iterable<Closeable> objects) throws E, IOException {
        Throwable th = null;
        for (Closeable object : objects) {
            try {
                if (object == null) continue;
                object.close();
            }
            catch (Throwable t) {
                if (th != null) continue;
                th = t;
            }
        }
        if (priorException != null) {
            throw priorException;
        }
        if (th != null) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    public static void closeSafely(boolean suppressExceptions, Closeable ... objects) throws IOException {
        Throwable th = null;
        for (Closeable object : objects) {
            try {
                if (object == null) continue;
                object.close();
            }
            catch (Throwable t) {
                if (th != null) continue;
                th = t;
            }
        }
        if (th != null && !suppressExceptions) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    public static void closeSafely(boolean suppressExceptions, Iterable<? extends Closeable> objects) throws IOException {
        Throwable th = null;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable t) {
                if (th != null) continue;
                th = t;
            }
        }
        if (th != null && !suppressExceptions) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }
}

