/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.sf.okapi.common.exceptions.OkapiIOException;

public class Base64 {
    private static final String ENCSTR = "#BeNcStr";
    private static final Charset CSUTF8;
    private static char[] map1;
    private static byte[] map2;

    public static String encodeString(String str) {
        return new String(Base64.encode(str.getBytes(CSUTF8)));
    }

    public static char[] encode(byte[] data) {
        return Base64.encode(data, data.length);
    }

    public static char[] encode(byte[] data, int iLen) {
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i0 = data[ip++] & 0xFF;
            int i1 = ip < iLen ? data[ip++] & 0xFF : 0;
            int i2 = ip < iLen ? data[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n;
            ++op;
        }
        return out;
    }

    public static String decodeString(String str) {
        str = str.replaceAll("[\r\n]", "");
        return new String(Base64.decode(str), CSUTF8);
    }

    public static byte[] decode(String str) {
        str = str.replaceAll("[\r\n]", "");
        return Base64.decode(str.toCharArray());
    }

    public static byte[] decode(char[] data) {
        int iLen = data.length;
        if (iLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (iLen > 0 && data[iLen - 1] == '=') {
            --iLen;
        }
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i3;
            char i0 = data[ip++];
            char i1 = data[ip++];
            int i2 = ip < iLen ? data[ip++] : 65;
            int n = i3 = ip < iLen ? data[ip++] : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0 = map2[i0];
            byte b1 = map2[i1];
            byte b2 = map2[i2];
            byte b3 = map2[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    public static String encode(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("Input stream for Base64 encoding cannot be null.");
        }
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[2048];
        int bytesRead = 0;
        try {
            while ((bytesRead = is.read(buffer)) > 0) {
                char[] chunk = Base64.encode(buffer, bytesRead);
                sb.append(chunk);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("I/O exception while reading data for Base64 encoding.", e);
        }
        return sb.toString();
    }

    public static String encodePassword(String password) {
        return ENCSTR + Base64.encodeString(password);
    }

    public static String decodePassword(String password) {
        if (password.startsWith(ENCSTR)) {
            return Base64.decodeString(password.substring(ENCSTR.length()));
        }
        return password;
    }

    static {
        int c;
        CSUTF8 = Charset.forName("UTF8");
        map1 = new char[64];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64.map1[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64.map1[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64.map1[i++] = c;
        }
        Base64.map1[i++] = 43;
        Base64.map1[i++] = 47;
        map2 = new byte[128];
        for (i = 0; i < map2.length; ++i) {
            Base64.map2[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Base64.map2[Base64.map1[i]] = (byte)i;
        }
    }
}

