/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.InlineAnnotation;

public class GenericAnnotations
extends InlineAnnotation
implements Iterable<GenericAnnotation> {
    private static final String ANNOTATION_SEPARATOR = "\u009a";
    private static final int INITIAL_SIZE = 1;
    private List<GenericAnnotation> list;

    public static void addAnnotations(IWithAnnotations nameable, GenericAnnotations newSet) {
        if (newSet == null) {
            return;
        }
        GenericAnnotations current = nameable.getAnnotation(GenericAnnotations.class);
        if (current == null) {
            nameable.setAnnotation(newSet);
        } else {
            current.addAll(newSet);
        }
    }

    public static void addAnnotations(Code code, GenericAnnotations newSet) {
        if (newSet == null) {
            return;
        }
        GenericAnnotations current = (GenericAnnotations)code.getAnnotation("generic");
        if (current == null) {
            code.setAnnotation("generic", newSet);
        } else {
            current.addAll(newSet);
        }
    }

    public GenericAnnotations() {
    }

    public GenericAnnotations(String storage) {
        this.fromString(storage);
    }

    public GenericAnnotations(GenericAnnotation annotation) {
        this.add(annotation);
    }

    @Override
    public GenericAnnotations clone() {
        GenericAnnotations newAnns = new GenericAnnotations(this.toString());
        if (newAnns.getData() != null) {
            newAnns.setData(Util.makeId(UUID.randomUUID().toString()));
        }
        return newAnns;
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public List<GenericAnnotation> getAnnotations(String type) {
        if (Util.isEmpty(this.list)) {
            return Collections.emptyList();
        }
        ArrayList<GenericAnnotation> res = new ArrayList<GenericAnnotation>();
        for (GenericAnnotation ann : this.list) {
            if (!ann.getType().equals(type)) continue;
            res.add(ann);
        }
        return res;
    }

    public GenericAnnotation getFirstAnnotation(String type) {
        if (Util.isEmpty(this.list)) {
            return null;
        }
        for (GenericAnnotation ann : this.list) {
            if (!ann.getType().equals(type)) continue;
            return ann;
        }
        return null;
    }

    public List<GenericAnnotation> getAllAnnotations() {
        if (Util.isEmpty(this.list)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.list);
    }

    public boolean hasAnnotation(String type) {
        if (Util.isEmpty(this.list)) {
            return false;
        }
        for (GenericAnnotation ann : this.list) {
            if (!ann.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.list != null) {
            this.list.clear();
        }
    }

    public void remove(GenericAnnotation annotation) {
        this.list.remove(annotation);
    }

    public GenericAnnotation add(String type) {
        GenericAnnotation ann = new GenericAnnotation(type);
        if (this.list == null) {
            this.list = new ArrayList<GenericAnnotation>(1);
        }
        this.list.add(ann);
        return ann;
    }

    public void add(GenericAnnotation annotation) {
        if (this.list == null) {
            this.list = new ArrayList<GenericAnnotation>(1);
        }
        if (annotation != null) {
            this.list.add(annotation);
        }
    }

    public void addAll(GenericAnnotations annotations) {
        if (annotations == null) {
            return;
        }
        if (annotations.size() == 0) {
            return;
        }
        if (this.list == null) {
            this.list = new ArrayList<GenericAnnotation>(annotations.size());
        }
        this.list.addAll(annotations.getAllAnnotations());
    }

    public void addAll(List<GenericAnnotation> newItems) {
        if (Util.isEmpty(newItems)) {
            return;
        }
        if (this.list == null) {
            this.list = new ArrayList<GenericAnnotation>(newItems.size());
        }
        this.list.addAll(newItems);
    }

    @Override
    public String toString() {
        if (Util.isEmpty(this.list)) {
            return this.data == null ? "" : this.data;
        }
        StringBuilder sb = new StringBuilder();
        if (this.data != null) {
            sb.append(this.data);
        }
        for (GenericAnnotation ann : this.list) {
            sb.append(ANNOTATION_SEPARATOR);
            sb.append(ann.toString());
        }
        return sb.toString();
    }

    @Override
    public void fromString(String storage) {
        String[] parts = storage.split(ANNOTATION_SEPARATOR, 0);
        if (!parts[0].isEmpty()) {
            this.data = parts[0];
        }
        for (int i = 1; i < parts.length; ++i) {
            GenericAnnotation ann = this.add("z");
            ann.fromString(parts[i]);
        }
    }

    @Override
    public Iterator<GenericAnnotation> iterator() {
        if (this.list == null) {
            List tmp = Collections.emptyList();
            return tmp.iterator();
        }
        return this.list.iterator();
    }
}

