/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;

public class Property {
    public static final String ENCODING = "encoding";
    public static final String LANGUAGE = "language";
    public static final String APPROVED = "approved";
    @Deprecated
    public static final String NOTE = "note";
    @Deprecated
    public static final String TRANSNOTE = "transNote";
    public static final String COORDINATES = "coordinates";
    public static final String STATE_QUALIFIER = "state-qualifier";
    public static final String STATE = "state";
    public static final String ITS_LQI = "locQualityIssuesRef";
    public static final String ITS_PROV = "provenanceRecordsRef";
    public static final String ITS_MTCONFIDENCE = "mtConfidence";
    public static final String XLIFF_TOOL = "tool";
    public static final String XLIFF_PHASE = "phase";
    public static final String MAX_WIDTH = "maxwidth";
    public static final String MAX_HEIGHT = "maxheight";
    public static final String SIZE_UNIT = "size-unit";
    private String name;
    private String value;
    private boolean isReadOnly;
    @Deprecated
    protected Annotations annotations;

    public Property() {
    }

    public Property(String name, String value, boolean isReadOnly) {
        this.name = name;
        this.value = value;
        this.isReadOnly = isReadOnly;
    }

    public Property(String name, String value) {
        this(name, value, true);
    }

    public String toString() {
        return this.value;
    }

    public Property clone() {
        Property prop = new Property(this.name, this.value, this.isReadOnly);
        return prop;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getBoolean() {
        if (this.value == null) {
            return false;
        }
        return this.value.equalsIgnoreCase("yes") || this.value.equalsIgnoreCase("true");
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Deprecated
    public <A extends IAnnotation> A getAnnotation(Class<A> type) {
        if (this.annotations == null) {
            return null;
        }
        return this.annotations.get(type);
    }

    @Deprecated
    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    @Deprecated
    public Annotations getAnnotations() {
        return this.annotations == null ? new Annotations() : this.annotations;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }
}

