/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeAnomalies;
import net.sf.okapi.common.resource.CodeComparatorOnData;
import net.sf.okapi.common.resource.CodeComparatorOnId;
import net.sf.okapi.common.resource.TextFragment;

public final class TextFragmentUtil {
    private static final int MAX_INLINE_CODES = 6127;

    public static CodeAnomalies catalogCodeAnomalies(TextFragment source, TextFragment target) {
        return TextFragmentUtil.catalogCodeAnomalies(source, target, true);
    }

    public static CodeAnomalies catalogCodeAnomalies(TextFragment source, TextFragment target, boolean includeDeletable) {
        Iterator<Code> i$;
        CodeAnomalies anomalies = new CodeAnomalies();
        if (source == null && target == null) {
            return null;
        }
        if (source == null) {
            if (!target.hasCode()) {
                return null;
            }
            i$ = target.getCodes().iterator();
            if (i$.hasNext()) {
                Code c = i$.next();
                if (!c.isAdded()) {
                    anomalies.addAddedCode(c);
                }
                return anomalies;
            }
        }
        if (target == null) {
            if (!source.hasCode()) {
                return null;
            }
            i$ = source.getCodes().iterator();
            if (i$.hasNext()) {
                Code c = i$.next();
                anomalies.addMissingCode(c);
                return anomalies;
            }
        }
        TreeSet<Code> sourceCodeSet = new TreeSet<Code>(new CodeComparatorOnData());
        TreeSet<Code> targetCodeSet = new TreeSet<Code>(new CodeComparatorOnData());
        if (source != null) {
            sourceCodeSet.addAll(source.getCodes());
        }
        if (target != null) {
            targetCodeSet.addAll(target.getCodes());
        }
        targetCodeSet.removeAll(sourceCodeSet);
        for (Code c : targetCodeSet) {
            if (c.isAdded() || c.isDeleteable() && !includeDeletable) continue;
            anomalies.addAddedCode(c);
        }
        if (target != null) {
            targetCodeSet.addAll(target.getCodes());
        }
        sourceCodeSet.removeAll(targetCodeSet);
        for (Code c : sourceCodeSet) {
            if (c.isDeleteable() && !includeDeletable) continue;
            anomalies.addMissingCode(c);
        }
        if (anomalies.hasAddedCodes() || anomalies.hasMissingCodes()) {
            return anomalies;
        }
        return null;
    }

    public static boolean moreThanMaxCodes(TextFragment tf) {
        List<Code> codes = tf.getCodes();
        return codes.size() > 6127;
    }

    public static TextFragment removeMoreThanMaxCodes(TextFragment tf) {
        int c;
        int i;
        int lastCodeIndex = 0;
        int lastCharIndex = 0;
        String codedText = tf.getCodedText();
        StringBuilder newCodedText = new StringBuilder();
        List<Code> codes = tf.getCodes();
        for (i = 0; i < codedText.length(); ++i) {
            c = codedText.codePointAt(i);
            if (c == 57601 || c == 57602 || c == 57603) {
                if (lastCodeIndex > 6126) {
                    lastCharIndex = i - 1;
                    break;
                }
                switch (c) {
                    case 57601: {
                        newCodedText.append("\ue101" + codedText.charAt(i + 1));
                        lastCodeIndex = TextFragment.toIndex(codedText.charAt(i + 1));
                        ++i;
                        break;
                    }
                    case 57602: {
                        newCodedText.append("\ue102" + codedText.charAt(i + 1));
                        lastCodeIndex = TextFragment.toIndex(codedText.charAt(i + 1));
                        ++i;
                        break;
                    }
                    case 57603: {
                        newCodedText.append("\ue103" + codedText.charAt(i + 1));
                        lastCodeIndex = TextFragment.toIndex(codedText.charAt(i + 1));
                        ++i;
                    }
                }
                continue;
            }
            newCodedText.appendCodePoint(c);
        }
        for (i = lastCharIndex; i < codedText.length(); ++i) {
            c = codedText.codePointAt(i);
            if (c == 57601 || c == 57602 || c == 57603) {
                ++i;
                continue;
            }
            newCodedText.appendCodePoint(c);
        }
        return new TextFragment(newCodedText.toString(), codes.subList(0, lastCodeIndex + 1));
    }

    public static String toText(TextFragment tf) {
        if (tf.codes == null || tf.codes.size() == 0) {
            return tf.toString();
        }
        if (!tf.isBalanced) {
            tf.balanceMarkers();
        }
        StringBuilder tmp = new StringBuilder();
        block3: for (int i = 0; i < tf.length(); ++i) {
            switch (tf.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    Code code = tf.codes.get(TextFragment.toIndex(tf.charAt(++i)));
                    tmp.append(code.getOuterData());
                    continue block3;
                }
                default: {
                    tmp.append(tf.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public static void copyCodes(TextFragment source, TextFragment target, boolean simplified) {
        if (target == null || !target.hasCode()) {
            return;
        }
        if (!source.isBalanced) {
            source.balanceMarkers();
        }
        if (!target.isBalanced) {
            target.balanceMarkers();
        }
        ArrayList<Boolean> finishedTargets = new ArrayList<Boolean>(Arrays.asList(new Boolean[target.getCodes().size()]));
        Collections.fill(finishedTargets, Boolean.FALSE);
        boolean hasData = true;
        for (Code tc : target.getCodes()) {
            if (tc.hasData()) continue;
            hasData = false;
            break;
        }
        Comparator<Code> cmp = null;
        cmp = hasData ? new CodeComparatorOnData() : new CodeComparatorOnId();
        for (Code sc : source.getCodes()) {
            int t = 0;
            for (Code tc : target.getCodes()) {
                if (cmp.compare(sc, tc) == 0 && !finishedTargets.get(t).booleanValue()) {
                    tc.setOuterData(null);
                    tc.setId(sc.getId());
                    tc.setReferenceFlag(sc.hasReference());
                    if (sc.hasOuterData()) {
                        tc.setOuterData(sc.getOuterData());
                    } else if (!tc.hasData()) {
                        tc.setData(sc.getData());
                    }
                    finishedTargets.set(t, true);
                }
                ++t;
            }
        }
    }
}

