/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.globalsight;

import com.globalsight.webservices.WebServiceException;
import com.globalsight.www.webservices.Ambassador;
import com.globalsight.www.webservices.AmbassadorWebServiceSoapBindingStub;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.globalsight.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import org.apache.axis.AxisFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GlobalSightTMConnector
extends BaseConnector
implements ITMQuery {
    private List<QueryResult> results;
    private int current = -1;
    private int maxHits = 25;
    private int threshold = 75;
    private Ambassador gsWS;
    private String gsToken;
    private String gsTmProfile;
    private Parameters params = new Parameters();
    private DocumentBuilder docBuilder;

    public GlobalSightTMConnector() {
        DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
        Fact.setValidating(false);
        try {
            this.docBuilder = Fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new OkapiException("Error creating document builder.", e);
        }
    }

    @Override
    public String getName() {
        return "GlobalSight-TM";
    }

    @Override
    public String getSettingsDisplay() {
        return String.format("URL: %s\nTM profile: %s", this.params.getServerURL(), this.params.getTmProfile());
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    @Override
    public void open() {
        try {
            URL url = new URL(this.params.getServerURL());
            this.gsWS = new AmbassadorWebServiceSoapBindingStub(url, null);
            this.gsToken = this.gsWS.login(this.params.getUsername(), this.params.getPassword());
            int n = this.gsToken.lastIndexOf("+_+");
            this.gsToken = this.gsToken.substring(0, n);
            this.gsTmProfile = this.params.getTmProfile();
            this.results = new ArrayList<QueryResult>();
        }
        catch (AxisFault e) {
            throw new OkapiException("Error creating the GlobalSight Web services.", e);
        }
        catch (RemoteException e) {
            throw new OkapiException("Error when login.", e);
        }
        catch (MalformedURLException e) {
            throw new OkapiException("Invalid server URL.", e);
        }
    }

    @Override
    public int query(TextFragment frag) {
        this.results.clear();
        if (!frag.hasText()) {
            return 0;
        }
        try {
            String text = frag.getCodedText();
            if (frag.hasCode()) {
                StringBuilder tmp = new StringBuilder();
                block10: for (int i = 0; i < text.length(); ++i) {
                    switch (text.charAt(i)) {
                        case '\ue101': {
                            Code code = frag.getCode(text.charAt(++i));
                            tmp.append(String.format("<bpt i=\"%d\" x=\"%d\" type=\"text\"/>", code.getId(), code.getId()));
                            continue block10;
                        }
                        case '\ue102': {
                            Code code = frag.getCode(text.charAt(++i));
                            tmp.append(String.format("<ept i=\"%d\"/>", code.getId() - 1));
                            continue block10;
                        }
                        case '\ue103': {
                            Code code = frag.getCode(text.charAt(++i));
                            tmp.append(String.format("<ph i=\"%d\" type=\"text\"/>", code.getId()));
                            continue block10;
                        }
                        default: {
                            tmp.append(text.charAt(i));
                        }
                    }
                }
                text = tmp.toString();
            }
            String xmlRes = this.gsWS.searchEntries(this.gsToken, this.gsTmProfile, text, this.srcCode);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlRes)));
            NodeList list1 = doc.getElementsByTagName("entry");
            for (int i = 0; i < list1.getLength() && i < this.maxHits; ++i) {
                Element elem = (Element)list1.item(i);
                NodeList list2 = elem.getElementsByTagName("percentage");
                QueryResult res = new QueryResult();
                res.weight = this.getWeight();
                res.setFuzzyScore(Float.valueOf(Util.getTextContent(list2.item(0)).replace("%", "")).intValue());
                if (res.getFuzzyScore() < this.threshold) continue;
                if (res.getFuzzyScore() >= 100) {
                    res.matchType = MatchType.EXACT;
                } else if (res.getFuzzyScore() > 0) {
                    res.matchType = MatchType.FUZZY;
                }
                list2 = elem.getElementsByTagName("tm");
                res.origin = Util.getTextContent(list2.item(0));
                list2 = elem.getElementsByTagName("source");
                NodeList list3 = ((Element)list2.item(0)).getElementsByTagName("segment");
                res.source = this.readSegment((Element)list3.item(0), frag);
                list2 = elem.getElementsByTagName("target");
                list3 = ((Element)list2.item(0)).getElementsByTagName("segment");
                res.target = this.readSegment((Element)list3.item(0), frag);
                this.results.add(res);
            }
        }
        catch (WebServiceException e) {
            throw new OkapiException("Error querying TM.", e);
        }
        catch (RemoteException e) {
            throw new OkapiException("Error querying TM.", e);
        }
        catch (SAXException e) {
            throw new OkapiException("Error with query results.", e);
        }
        catch (IOException e) {
            throw new OkapiException("Error with query results.", e);
        }
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        throw new OkapiNotImplementedException();
    }

    @Override
    public int query(String plainText) {
        try {
            this.results.clear();
            String xmlRes = this.gsWS.searchEntries(this.gsToken, this.gsTmProfile, plainText, this.srcCode);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(xmlRes)));
            NodeList list1 = doc.getElementsByTagName("entry");
            for (int i = 0; i < list1.getLength() && i < this.maxHits; ++i) {
                Element elem = (Element)list1.item(i);
                NodeList list2 = elem.getElementsByTagName("percentage");
                QueryResult res = new QueryResult();
                res.weight = this.getWeight();
                res.setFuzzyScore(Float.valueOf(Util.getTextContent(list2.item(0)).replace("%", "")).intValue());
                if (res.getFuzzyScore() < this.threshold) continue;
                list2 = elem.getElementsByTagName("source");
                NodeList list3 = ((Element)list2.item(0)).getElementsByTagName("segment");
                res.source = this.readSegment((Element)list3.item(0), null);
                list2 = elem.getElementsByTagName("target");
                list3 = ((Element)list2.item(0)).getElementsByTagName("segment");
                res.target = this.readSegment((Element)list3.item(0), null);
                this.results.add(res);
            }
        }
        catch (WebServiceException e) {
            throw new OkapiException("Error querying TM.", e);
        }
        catch (RemoteException e) {
            throw new OkapiException("Error querying TM.", e);
        }
        catch (SAXException e) {
            throw new OkapiException("Error with query results.", e);
        }
        catch (IOException e) {
            throw new OkapiException("Error with query results.", e);
        }
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    private TextFragment readSegment(Element elem, TextFragment original) {
        TextFragment tf = new TextFragment();
        NodeList list = elem.getChildNodes();
        int lastId = -1;
        int id = -1;
        Stack<Code> stack = new Stack<Code>();
        block4: for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            switch (node.getNodeType()) {
                case 3: {
                    tf.append(node.getNodeValue());
                    continue block4;
                }
                case 1: {
                    NamedNodeMap map = node.getAttributes();
                    Node attr = map.getNamedItem("type");
                    if (node.getNodeName().equals("bpt")) {
                        id = this.getRawIndex(lastId, map.getNamedItem("x"));
                        stack.push(tf.append(TextFragment.TagType.OPENING, attr == null ? "Xpt" : attr.getNodeValue(), String.format("{%d}", id), id));
                        continue block4;
                    }
                    if (node.getNodeName().equals("ept")) {
                        Code code = (Code)stack.pop();
                        tf.append(TextFragment.TagType.CLOSING, code.getType(), String.format("{/%d}", code.getId()), code.getId());
                        continue block4;
                    }
                    if (node.getNodeName().equals("ph")) {
                        id = this.getRawIndex(lastId, map.getNamedItem("x"));
                        tf.append(TextFragment.TagType.PLACEHOLDER, attr == null ? "ph" : attr.getNodeValue(), String.format("{%d/}", id), id);
                        continue block4;
                    }
                    if (!node.getNodeName().equals("it")) continue block4;
                    Node pos = map.getNamedItem("pos");
                    if (pos == null) {
                        id = this.getRawIndex(lastId, map.getNamedItem("x"));
                        tf.append(TextFragment.TagType.PLACEHOLDER, attr == null ? "ph" : attr.getNodeValue(), "[it/]", id);
                        continue block4;
                    }
                    if (pos.getNodeValue().equals("begin")) {
                        id = this.getRawIndex(lastId, map.getNamedItem("x"));
                        tf.append(TextFragment.TagType.OPENING, attr == null ? "Xpt" : attr.getNodeValue(), "[it-bpt/]", id);
                        continue block4;
                    }
                    tf.append(TextFragment.TagType.CLOSING, attr == null ? "Xpt" : attr.getNodeValue(), "[it-ept/]");
                }
            }
        }
        return tf;
    }

    private int getRawIndex(int lastIndex, Node attr) {
        if (attr == null) {
            return ++lastIndex;
        }
        return Integer.valueOf(attr.getNodeValue());
    }

    @Override
    public void removeAttribute(String name) {
    }

    @Override
    public void clearAttributes() {
    }

    @Override
    public void setAttribute(String name, String value) {
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        return locale.toPOSIXLocaleId();
    }

    @Override
    public void setMaximumHits(int max) {
        this.maxHits = max;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public int getMaximumHits() {
        return this.maxHits;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setRootDirectory(String rootDir) {
    }
}

