/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.google.FragmentQueryResultBuilder;
import net.sf.okapi.connectors.google.GoogleMTAPI;
import net.sf.okapi.connectors.google.GoogleMTAPIImpl;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;
import net.sf.okapi.connectors.google.QueryResultBuilder;
import net.sf.okapi.connectors.google.TextQueryResultBuilder;
import net.sf.okapi.connectors.google.TranslationResponse;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryUtil;

public class GoogleMTv2Connector
extends BaseConnector {
    private static final String BASE_URL = "https://translation.googleapis.com/language/translate/v2";
    private static final int RETRIES = 3;
    private static final int SLEEPPAUSE = 300;
    private GoogleMTv2Parameters params = new GoogleMTv2Parameters();
    private QueryUtil util = new QueryUtil();
    private GoogleMTAPI api = new GoogleMTAPIImpl("https://translation.googleapis.com/language/translate/v2", this.params);

    @Override
    public void setParameters(IParameters params) {
        this.params = (GoogleMTv2Parameters)params;
    }

    @Override
    public GoogleMTv2Parameters getParameters() {
        return this.params;
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "Google-MTv2";
    }

    @Override
    public String getSettingsDisplay() {
        return "Server: https://translation.googleapis.com/language/translate/v2";
    }

    @Override
    public void open() {
    }

    @Override
    public int query(String plainText) {
        return this._query(plainText, plainText, new TextQueryResultBuilder(this.params, this.getName(), this.getWeight()));
    }

    @Override
    public int query(TextFragment frag) {
        return this._query(this.util.toCodedHTML(frag), frag, new FragmentQueryResultBuilder(this.params, this.getName(), this.getWeight()));
    }

    protected <T> int _query(String queryText, T originalText, QueryResultBuilder<T> resultBuilder) {
        this.current = -1;
        if (queryText.isEmpty()) {
            return 0;
        }
        if (Util.isEmpty(this.params.getApiKey())) {
            throw new OkapiException("You must have a Google API Key to use this connector.");
        }
        List<Object> queryResults = new ArrayList();
        try {
            for (int tries = 0; tries < 3; ++tries) {
                List<TranslationResponse> responses = this.api.translate(this.srcCode, this.trgCode, Collections.singletonList(queryText));
                if (responses != null) {
                    queryResults = resultBuilder.convertResponses(responses, originalText);
                    break;
                }
                try {
                    Thread.sleep(300L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new OkapiException("Interrupted while trying to contact Google MT");
                }
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error querying the MT server: " + e.getMessage(), e);
        }
        if (queryResults.size() > 0) {
            this.current = 0;
            this.result = (QueryResult)queryResults.iterator().next();
            return 1;
        }
        throw new OkapiException("Could not retrieve results from Google after 3 attempts.");
    }

    public List<List<QueryResult>> batchQueryText(List<String> plainTexts) {
        return this._batchQuery(plainTexts, plainTexts, new TextQueryResultBuilder(this.params, this.getName(), this.getWeight()));
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        return this._batchQuery(this.util.toCodedHTML(fragments), fragments, new FragmentQueryResultBuilder(this.params, this.getName(), this.getWeight()));
    }

    protected <T> List<List<QueryResult>> _batchQuery(List<String> texts, List<T> originalText, QueryResultBuilder<T> qrBuilder) {
        this.current = -1;
        ArrayList<List<QueryResult>> queryResults = new ArrayList<List<QueryResult>>(texts.size());
        try {
            for (int tries = 0; tries < 3; ++tries) {
                List<TranslationResponse> responses = this.api.translate(this.srcCode, this.trgCode, texts);
                if (responses != null) {
                    for (int i = 0; i < responses.size(); ++i) {
                        queryResults.add(qrBuilder.convertResponses(Collections.singletonList(responses.get(i)), originalText.get(i)));
                    }
                    break;
                }
                try {
                    Thread.sleep(300L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new OkapiException("Interrupted while trying to contact Google MT");
                }
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error querying the MT server: " + e.getMessage(), e);
        }
        return queryResults;
    }

    @Override
    public void leverage(ITextUnit tu) {
        this.leverageUsingBatchQuery(tu);
    }

    @Override
    public void batchLeverage(List<ITextUnit> tuList) {
        this.batchLeverageUsingBatchQuery(tuList);
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String code = locale.toBCP47();
        if (!code.startsWith("zh") && code.length() > 2) {
            code = code.substring(0, 2);
        }
        return code;
    }
}

