/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.connectors.microsoft.TranslationResponse;

public class GetTranslationsResponseParser {
    public List<TranslationResponse> parseGetTranslationsResponse(String block, int maxHits, int threshold) {
        int n1;
        ArrayList<TranslationResponse> list = new ArrayList<TranslationResponse>(maxHits);
        int from = 0;
        if (block == null) {
            return list;
        }
        while ((n1 = block.indexOf("<TranslationMatch>", from)) >= 0) {
            int n2 = block.indexOf("</TranslationMatch>", n1);
            String res = block.substring(n1, n2);
            from = n2 + 1;
            n1 = res.indexOf("<MatchDegree>");
            n2 = res.indexOf("</MatchDegree>", n1 + 1);
            int score = Integer.parseInt(res.substring(n1 + 13, n2));
            int rating = 5;
            n1 = res.indexOf("<Rating", 0);
            n2 = res.indexOf("</Rating>", n1);
            if (n2 > -1) {
                rating = Integer.parseInt(res.substring(n1 + 8, n2));
                if (rating < -10) {
                    rating = -10;
                } else if (rating > 10) {
                    rating = 10;
                }
            }
            n1 = res.indexOf("<MatchedOriginalText", 0);
            n2 = res.indexOf("</MatchedOriginalText", n1);
            String stext = null;
            if (n2 > -1) {
                stext = this.unescapeXML(res.substring(n1 + 21, n2));
            }
            String ttext = "";
            n1 = res.indexOf("<TranslatedText", n2);
            if ((n2 = res.indexOf("</TranslatedText", n1)) > -1) {
                ttext = this.unescapeXML(res.substring(n1 + 16, n2));
            }
            TranslationResponse response = new TranslationResponse(stext, ttext, rating, score);
            if (response.combinedScore < threshold) continue;
            list.add(response);
            if (list.size() < maxHits) continue;
            break;
        }
        return list;
    }

    private String unescapeXML(String text) {
        text = text.replace("&apos;", "'");
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&quot;", "\"");
        return text.replace("&amp;", "&");
    }

    public List<List<TranslationResponse>> parseGetTranslationsArrayResponse(String block, int maxHits, int threshold) {
        ArrayList<List<TranslationResponse>> responses = new ArrayList<List<TranslationResponse>>();
        if (block == null) {
            return responses;
        }
        int from = 0;
        from = block.indexOf("<Translations>", from);
        while (from >= 0) {
            int n = block.indexOf("</Translations>", from);
            String subBlock = block.substring(from, n);
            responses.add(this.parseGetTranslationsResponse(subBlock, maxHits, threshold));
            from = n + 1;
            from = block.indexOf("<Translations>", from);
        }
        return responses;
    }
}

