/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.simpletm;

import java.util.LinkedHashMap;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.simpletm.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.tm.simpletm.Database;

public class SimpleTMConnector
extends BaseConnector
implements ITMQuery {
    private Database db;
    private int maxHits = 5;
    private int threshold = 98;
    private List<QueryResult> results;
    private int current = -1;
    private LinkedHashMap<String, String> attributes;
    private Parameters params = new Parameters();
    private String rootDir;

    public SimpleTMConnector() {
        this.db = new Database();
        this.attributes = new LinkedHashMap();
    }

    @Override
    public String getName() {
        return "SimpleTM";
    }

    @Override
    public String getSettingsDisplay() {
        return String.format("Database: %s\nPenalize exact matches with different codes in source: %s, in target: %s", Util.isEmpty(this.params.getDbPath()) ? "<To be specified>" : this.params.getDbPath(), this.params.getPenalizeSourceWithDifferentCodes() ? "Yes" : "No", this.params.getPenalizeTargetWithDifferentCodes() ? "Yes" : "No");
    }

    @Override
    public void setMaximumHits(int max) {
        this.maxHits = max < 1 ? 1 : max;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void close() {
        this.db.close();
    }

    @Override
    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    @Override
    public void open() {
        this.db.open(Util.fillRootDirectoryVariable(this.params.getDbPath(), this.rootDir));
        this.db.setPenalizeSourceWithDifferentCodes(this.params.getPenalizeSourceWithDifferentCodes());
        this.db.setPenalizeTargetWithDifferentCodes(this.params.getPenalizeTargetWithDifferentCodes());
    }

    @Override
    public int query(String plainText) {
        TextFragment tf = new TextFragment(plainText);
        return this.query(tf);
    }

    @Override
    public int query(TextFragment text) {
        this.current = -1;
        this.results = this.db.query(text, this.attributes, this.maxHits, this.threshold);
        if (this.results == null) {
            return 0;
        }
        this.current = 0;
        return this.results.size();
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        throw new OkapiNotImplementedException();
    }

    @Override
    public void setAttribute(String name, String value) {
        assert (value != null);
        if ("resname".equals(name)) {
            name = "Name";
        }
        if ("restype".equals(name)) {
            name = "Type";
        }
        if (this.attributes.put(name, value) == null) {
            this.db.createStatement(this.attributes);
        }
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
        this.db.clearAttributes();
    }

    @Override
    public void removeAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            this.attributes.remove(name);
            this.db.createStatement(this.attributes);
        }
    }

    @Override
    public int getMaximumHits() {
        return this.maxHits;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }
}

