/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.dtd;

import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.filters.LocalizationDirectives;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

public class Parameters
extends StringParameters
implements ISimplifierRulesParameters {
    private static final String USECODEFINDER = "useCodeFinder";
    public InlineCodeFinder codeFinder;
    public LocalizationDirectives locDir;

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    @Override
    public void reset() {
        super.reset();
        this.locDir = new LocalizationDirectives();
        this.codeFinder = new InlineCodeFinder();
        this.setUseCodeFinder(true);
        this.codeFinder.setSample("&name; <tag></at><tag/> <tag attr='val'> </tag=\"val\">");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("</?([A-Z0-9a-z]*)\\b[^>]*>");
        this.setSimplifierRules(null);
    }

    @Override
    public String toString() {
        this.buffer.setBoolean("useLD", this.locDir.useLD());
        this.buffer.setBoolean("localizeOutside", this.locDir.localizeOutside());
        this.buffer.setGroup("codeFinderRules", this.codeFinder.toString());
        return this.buffer.toString();
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        boolean tmpBool1 = this.buffer.getBoolean("useLD", this.locDir.useLD());
        boolean tmpBool2 = this.buffer.getBoolean("localizeOutside", this.locDir.localizeOutside());
        this.locDir.setOptions(tmpBool1, tmpBool2);
        this.codeFinder.fromString(this.buffer.getGroup("codeFinderRules", ""));
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }
}

