/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.idml.NodeReference;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class IDMLSkeleton
implements ISkeleton {
    public static final String NODEREMARKER = "SKLREF";
    private ZipFile original;
    private ZipEntry entry;
    private Document doc;
    private Node topNode;
    private Node scopeNode;
    private HashMap<String, NodeReference> refs;
    private TextFragment[] movedParts;
    private boolean forced = false;

    public IDMLSkeleton(ZipFile original) {
        this.original = original;
    }

    public IDMLSkeleton(ZipFile original, ZipEntry entry, Document doc) {
        this.original = original;
        this.entry = entry;
        this.doc = doc;
    }

    public IDMLSkeleton(Node topNode, Node scopeNode) {
        this.topNode = topNode;
        this.scopeNode = scopeNode;
    }

    public void addReferenceNode(String id, NodeReference ref) {
        if (this.refs == null) {
            this.refs = new HashMap();
        }
        this.refs.put(id, ref);
    }

    public void addMovedParts(TextFragment[] movedParts) {
        this.movedParts = movedParts;
    }

    public TextFragment[] getMovedParts() {
        return this.movedParts;
    }

    public boolean hasReferences() {
        return this.refs != null && this.refs.size() > 0;
    }

    public HashMap<String, NodeReference> getReferences() {
        return this.refs;
    }

    public ZipFile getOriginal() {
        return this.original;
    }

    public ZipEntry getEntry() {
        return this.entry;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public Node getScopeNode() {
        return this.scopeNode;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public boolean getForced() {
        return this.forced;
    }

    @Override
    public IDMLSkeleton clone() {
        IDMLSkeleton newSkel = new IDMLSkeleton(this.original);
        newSkel.entry = this.entry;
        newSkel.doc = this.doc;
        newSkel.topNode = this.topNode;
        newSkel.scopeNode = this.scopeNode;
        newSkel.refs = this.refs;
        newSkel.movedParts = this.movedParts;
        return newSkel;
    }

    @Override
    public void setParent(IResource parent) {
    }

    @Override
    public IResource getParent() {
        return null;
    }
}

