/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown;

import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;

public class Parameters
extends StringParameters {
    public static final String HTML_RULE = "</?\\w+/?>";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String TRANSLATE_URLS = "translateUrls";
    private InlineCodeFinder codeFinder;

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public boolean getTranslateUrls() {
        return this.getBoolean(TRANSLATE_URLS);
    }

    public void setTranslateUrls(boolean translateUrls) {
        this.setBoolean(TRANSLATE_URLS, translateUrls);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    @Override
    public void reset() {
        super.reset();
        this.setUseCodeFinder(true);
        this.setTranslateUrls(false);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("<table><tr><td>Test</td></tr></table>");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule(HTML_RULE);
        this.codeFinder.addRule("#+");
        this.codeFinder.addRule("~{1,2}");
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }
}

