/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown.parser;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.BlankLine;
import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.CustomBlock;
import com.vladsch.flexmark.ast.CustomNode;
import com.vladsch.flexmark.ast.DelimitedNodeImpl;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlBlockBase;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.ast.InlineLinkNode;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitor;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.ThematicBreak;
import com.vladsch.flexmark.ast.VisitHandler;
import com.vladsch.flexmark.ast.Visitor;
import com.vladsch.flexmark.ast.WhiteSpace;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import net.sf.okapi.filters.markdown.Parameters;
import net.sf.okapi.filters.markdown.parser.MarkdownToken;
import net.sf.okapi.filters.markdown.parser.MarkdownTokenType;

public class MarkdownParser {
    private static final MutableDataHolder OPTIONS = new MutableDataSet().set((DataKey)Parser.EXTENSIONS, Arrays.asList(TablesExtension.create()));
    private static final Parser PARSER = Parser.builder(OPTIONS).build();
    private String newline = System.lineSeparator();
    private Node root = null;
    private Deque<MarkdownToken> tokenQueue = new LinkedList<MarkdownToken>();
    private boolean lastAddedTranslatableContent = false;
    private int numNonTranslatableNewlines = 0;
    private Parameters params;
    private NodeVisitor visitor = new NodeVisitor((VisitHandler<?>[])new VisitHandler[]{new VisitHandler<AutoLink>(AutoLink.class, new Visitor<AutoLink>(){

        @Override
        public void visit(AutoLink node) {
            MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.AUTO_LINK, node);
        }
    }), new VisitHandler<BlankLine>(BlankLine.class, new Visitor<BlankLine>(){

        @Override
        public void visit(BlankLine node) {
            MarkdownParser.this.visitBlock(node, false, MarkdownTokenType.BLANK_LINE);
        }
    }), new VisitHandler<BlockQuote>(BlockQuote.class, new Visitor<BlockQuote>(){

        @Override
        public void visit(BlockQuote node) {
            MarkdownParser.this.addToQueue(node.getOpeningMarker().toString() + " ", false, MarkdownTokenType.BLOCK_QUOTE, node);
            MarkdownParser.this.visitor.visitChildren(node);
            MarkdownParser.this.addBlockNewlines(node);
        }
    }), new VisitHandler<BulletList>(BulletList.class, new Visitor<BulletList>(){

        @Override
        public void visit(BulletList node) {
            MarkdownParser.this.visitListBlock(node, MarkdownTokenType.BULLET_LIST);
        }
    }), new VisitHandler<BulletListItem>(BulletListItem.class, new Visitor<BulletListItem>(){

        @Override
        public void visit(BulletListItem node) {
            MarkdownParser.this.visitListItem(node, MarkdownTokenType.BULLET_LIST_ITEM);
        }
    }), new VisitHandler<Code>(Code.class, new Visitor<Code>(){

        @Override
        public void visit(Code node) {
            MarkdownParser.this.visitDelimitedNode(node, MarkdownTokenType.CODE);
        }
    }), new VisitHandler<CustomBlock>(CustomBlock.class, new Visitor<CustomBlock>(){

        @Override
        public void visit(CustomBlock node) {
            MarkdownParser.this.visitor.visitChildren(node);
            MarkdownParser.this.addBlockNewlines(node);
        }
    }), new VisitHandler<CustomNode>(CustomNode.class, new Visitor<CustomNode>(){

        @Override
        public void visit(CustomNode node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<Document>(Document.class, new Visitor<Document>(){

        @Override
        public void visit(Document node) {
            MarkdownParser.this.visitor.visitChildren(node);
            MarkdownParser.this.addBlockNewlines(node);
        }
    }), new VisitHandler<Emphasis>(Emphasis.class, new Visitor<Emphasis>(){

        @Override
        public void visit(Emphasis node) {
            MarkdownParser.this.visitDelimitedNode(node, MarkdownTokenType.EMPHASIS);
        }
    }), new VisitHandler<FencedCodeBlock>(FencedCodeBlock.class, new Visitor<FencedCodeBlock>(){

        @Override
        public void visit(FencedCodeBlock node) {
            MarkdownParser.this.addToQueue(node.getOpeningFence().toString(), false, MarkdownTokenType.FENCED_CODE_BLOCK, node);
            if (MarkdownParser.this.isDefined(node.getInfo())) {
                MarkdownParser.this.addToQueue(node.getInfo().toString(), true, MarkdownTokenType.FENCED_CODE_BLOCK_INFO, node);
            }
            MarkdownParser.this.addToQueue(MarkdownParser.this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
            MarkdownParser.this.addToQueue(node.getContentChars().toString().trim(), true, MarkdownTokenType.TEXT, node);
            MarkdownParser.this.addToQueue(MarkdownParser.this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
            MarkdownParser.this.removeDuplicateNewlinesAtQueueTail();
            MarkdownParser.this.addToQueue(node.getClosingFence().toString(), false, MarkdownTokenType.FENCED_CODE_BLOCK, node);
            MarkdownParser.this.addBlockNewlines(node);
        }
    }), new VisitHandler<HardLineBreak>(HardLineBreak.class, new Visitor<HardLineBreak>(){

        @Override
        public void visit(HardLineBreak node) {
            MarkdownParser.this.addToQueue(MarkdownParser.this.newline, true, MarkdownTokenType.HARD_LINE_BREAK, node);
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<Heading>(Heading.class, new Visitor<Heading>(){

        @Override
        public void visit(Heading node) {
            if (node.getOpeningMarker() != BasedSequence.NULL) {
                MarkdownParser.this.addToQueue(node.getOpeningMarker().toString() + " ", false, MarkdownTokenType.HEADING_PREFIX, node);
            }
            MarkdownParser.this.visitor.visitChildren(node);
            MarkdownParser.this.addToQueue(MarkdownParser.this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
            if (node.getClosingMarker() != BasedSequence.NULL) {
                MarkdownParser.this.addToQueue(node.getClosingMarker().toString(), false, MarkdownTokenType.HEADING_UNDERLINE, node);
            }
            MarkdownParser.this.addBlockNewlines(node);
        }
    }), new VisitHandler<HtmlBlock>(HtmlBlock.class, new Visitor<HtmlBlock>(){

        @Override
        public void visit(HtmlBlock node) {
            MarkdownParser.this.visitHtmlBlockBase(node, MarkdownTokenType.HTML_BLOCK);
        }
    }), new VisitHandler<HtmlCommentBlock>(HtmlCommentBlock.class, new Visitor<HtmlCommentBlock>(){

        @Override
        public void visit(HtmlCommentBlock node) {
            MarkdownParser.this.visitHtmlBlockBase(node, MarkdownTokenType.HTML_COMMENT_BLOCK);
        }
    }), new VisitHandler<HtmlEntity>(HtmlEntity.class, new Visitor<HtmlEntity>(){

        @Override
        public void visit(HtmlEntity node) {
            MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.HTML_ENTITY, node);
        }
    }), new VisitHandler<HtmlInline>(HtmlInline.class, new Visitor<HtmlInline>(){

        @Override
        public void visit(HtmlInline node) {
            MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.HTML_INLINE, node);
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<HtmlInlineComment>(HtmlInlineComment.class, new Visitor<HtmlInlineComment>(){

        @Override
        public void visit(HtmlInlineComment node) {
            MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.HTML_INLINE_COMMENT, node);
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<HtmlInnerBlock>(HtmlInnerBlock.class, new Visitor<HtmlInnerBlock>(){

        @Override
        public void visit(HtmlInnerBlock node) {
            MarkdownParser.this.visitHtmlBlockBase(node, MarkdownTokenType.HTML_INNER_BLOCK);
        }
    }), new VisitHandler<HtmlInnerBlockComment>(HtmlInnerBlockComment.class, new Visitor<HtmlInnerBlockComment>(){

        @Override
        public void visit(HtmlInnerBlockComment node) {
            MarkdownParser.this.visitHtmlBlockBase(node, MarkdownTokenType.HTML_INNER_BLOCK_COMMENT);
        }
    }), new VisitHandler<Image>(Image.class, new Visitor<Image>(){

        @Override
        public void visit(Image node) {
            MarkdownParser.this.visitInlineLink(node, MarkdownTokenType.IMAGE);
        }
    }), new VisitHandler<ImageRef>(ImageRef.class, new Visitor<ImageRef>(){

        @Override
        public void visit(ImageRef node) {
            MarkdownParser.this.visitRefDeclaration(node, MarkdownTokenType.IMAGE_REF);
        }
    }), new VisitHandler<IndentedCodeBlock>(IndentedCodeBlock.class, new Visitor<IndentedCodeBlock>(){

        @Override
        public void visit(IndentedCodeBlock node) {
            for (BasedSequence seq : node.getContentChars().split(MarkdownParser.this.newline)) {
                MarkdownParser.this.addToQueue("    ", false, MarkdownTokenType.INDENTED_CODE_BLOCK, node);
                MarkdownParser.this.addToQueue(seq.toString().trim(), true, MarkdownTokenType.TEXT, node);
                MarkdownParser.this.addToQueue(MarkdownParser.this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
            }
            MarkdownParser.this.addBlockNewlines(node);
        }
    }), new VisitHandler<Link>(Link.class, new Visitor<Link>(){

        @Override
        public void visit(Link node) {
            MarkdownParser.this.visitInlineLink(node, MarkdownTokenType.LINK);
        }
    }), new VisitHandler<LinkRef>(LinkRef.class, new Visitor<LinkRef>(){

        @Override
        public void visit(LinkRef node) {
            MarkdownParser.this.visitRefDeclaration(node, MarkdownTokenType.LINK_REF);
        }
    }), new VisitHandler<MailLink>(MailLink.class, new Visitor<MailLink>(){

        @Override
        public void visit(MailLink node) {
            MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.MAIL_LINK, node);
        }
    }), new VisitHandler<Paragraph>(Paragraph.class, new Visitor<Paragraph>(){

        @Override
        public void visit(Paragraph node) {
            MarkdownParser.this.visitor.visitChildren(node);
            MarkdownParser.this.addBlockNewlines(node);
        }
    }), new VisitHandler<OrderedList>(OrderedList.class, new Visitor<OrderedList>(){

        @Override
        public void visit(OrderedList node) {
            MarkdownParser.this.visitListBlock(node, MarkdownTokenType.ORDERED_LIST);
        }
    }), new VisitHandler<OrderedListItem>(OrderedListItem.class, new Visitor<OrderedListItem>(){

        @Override
        public void visit(OrderedListItem node) {
            MarkdownParser.this.visitListItem(node, MarkdownTokenType.ORDERED_LIST_ITEM);
        }
    }), new VisitHandler<Reference>(Reference.class, new Visitor<Reference>(){

        @Override
        public void visit(Reference node) {
            MarkdownParser.this.visitReferenceDefinition(node, MarkdownTokenType.REFERENCE);
        }
    }), new VisitHandler<SoftLineBreak>(SoftLineBreak.class, new Visitor<SoftLineBreak>(){

        @Override
        public void visit(SoftLineBreak node) {
            MarkdownParser.this.addToQueue(MarkdownParser.this.newline, true, MarkdownTokenType.SOFT_LINE_BREAK, node);
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<StrongEmphasis>(StrongEmphasis.class, new Visitor<StrongEmphasis>(){

        @Override
        public void visit(StrongEmphasis node) {
            MarkdownParser.this.visitDelimitedNode(node, MarkdownTokenType.STRONG_EMPHASIS);
        }
    }), new VisitHandler<Text>(Text.class, new Visitor<Text>(){

        @Override
        public void visit(Text node) {
            if (node.getChars().toString().isEmpty()) {
                return;
            }
            if (node.getChars().toString().trim().isEmpty() || node.getAncestorOfType(TableSeparator.class) != null) {
                MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.TEXT, node);
            } else {
                MarkdownParser.this.addToQueue(node.getChars().toString(), true, MarkdownTokenType.TEXT, node);
            }
        }
    }), new VisitHandler<TextBase>(TextBase.class, new Visitor<TextBase>(){

        @Override
        public void visit(TextBase node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<ThematicBreak>(ThematicBreak.class, new Visitor<ThematicBreak>(){

        @Override
        public void visit(ThematicBreak node) {
            MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.THEMATIC_BREAK, node);
            MarkdownParser.this.addBlockNewlines(node);
        }
    }), new VisitHandler<WhiteSpace>(WhiteSpace.class, new Visitor<WhiteSpace>(){

        @Override
        public void visit(WhiteSpace node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<TableBlock>(TableBlock.class, new Visitor<TableBlock>(){

        @Override
        public void visit(TableBlock node) {
            MarkdownParser.this.visitor.visitChildren(node);
            MarkdownParser.this.addToQueue(MarkdownParser.this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
        }
    }), new VisitHandler<TableBody>(TableBody.class, new Visitor<TableBody>(){

        @Override
        public void visit(TableBody node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<TableCaption>(TableCaption.class, new Visitor<TableCaption>(){

        @Override
        public void visit(TableCaption node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<TableCell>(TableCell.class, new Visitor<TableCell>(){

        @Override
        public void visit(TableCell node) {
            MarkdownParser.this.addToQueue("| ", false, MarkdownTokenType.TABLE_PIPE, node);
            MarkdownParser.this.visitor.visitChildren(node);
            MarkdownParser.this.addToQueue(" ", false, MarkdownTokenType.WHITE_SPACE, node);
        }
    }), new VisitHandler<TableHead>(TableHead.class, new Visitor<TableHead>(){

        @Override
        public void visit(TableHead node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<TableRow>(TableRow.class, new Visitor<TableRow>(){

        @Override
        public void visit(TableRow node) {
            MarkdownParser.this.visitor.visitChildren(node);
            MarkdownParser.this.addToQueue("|", false, MarkdownTokenType.TABLE_PIPE, node);
            MarkdownParser.this.addToQueue(MarkdownParser.this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
        }
    }), new VisitHandler<TableSeparator>(TableSeparator.class, new Visitor<TableSeparator>(){

        @Override
        public void visit(TableSeparator node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    })});

    public MarkdownParser(Parameters params) {
        this.params = params;
    }

    public MarkdownParser(Parameters params, String newline) {
        this(params);
        this.newline = newline;
    }

    public void parse(String markdownContent) {
        this.root = PARSER.parse(markdownContent);
        this.tokenQueue.clear();
        this.numNonTranslatableNewlines = 0;
        this.lastAddedTranslatableContent = false;
        this.visitor.visit(this.root);
    }

    public boolean hasNextToken() {
        return !this.tokenQueue.isEmpty();
    }

    public MarkdownToken getNextToken() {
        if (!this.hasNextToken()) {
            throw new IllegalStateException("No more tokens remaining");
        }
        return this.tokenQueue.removeFirst();
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.generateAstString(this.root, 0, builder);
        return builder.toString();
    }

    private void generateAstString(Node node, int depth, StringBuilder builder) {
        builder.append(node + " (depth: " + depth + ")" + this.newline);
        for (Node child : node.getChildren()) {
            this.generateAstString(child, depth + 1, builder);
        }
    }

    private void addToQueue(String content, boolean isTranslatable, MarkdownTokenType type, Node node) {
        if (content.equals(this.newline) && !isTranslatable) {
            this.lastAddedTranslatableContent = isTranslatable;
            ++this.numNonTranslatableNewlines;
            if (this.numNonTranslatableNewlines <= 2) {
                this.addListPaddingCharacters(content, node);
                this.tokenQueue.addLast(new MarkdownToken(content, isTranslatable, type));
            }
            return;
        }
        if (this.lastAddedTranslatableContent && isTranslatable) {
            MarkdownToken token = this.tokenQueue.peekLast();
            token.setContent(token.getContent() + content);
            return;
        }
        this.numNonTranslatableNewlines = 0;
        this.lastAddedTranslatableContent = isTranslatable;
        this.addListPaddingCharacters(content, node);
        this.tokenQueue.addLast(new MarkdownToken(content, isTranslatable, type));
    }

    private void addListPaddingCharacters(String content, Node node) {
        if (content.equals(this.newline)) {
            return;
        }
        MarkdownToken lastToken = this.tokenQueue.peekLast();
        if (lastToken == null || !lastToken.getContent().equals(this.newline)) {
            return;
        }
        int depth = 1;
        if (node instanceof BulletListItem || node instanceof OrderedListItem) {
            depth = 0;
        }
        Node ancestor = node.getAncestorOfType(BulletList.class, OrderedList.class);
        while (ancestor != null) {
            ancestor = ancestor.getAncestorOfType(BulletList.class, OrderedList.class);
            ++depth;
        }
        StringBuilder padding = new StringBuilder();
        for (int i = 1; i < depth; ++i) {
            padding.append("   ");
        }
        if (padding.length() > 0) {
            this.tokenQueue.addLast(new MarkdownToken(padding.toString(), false, MarkdownTokenType.WHITE_SPACE));
        }
    }

    private void removeDuplicateNewlinesAtQueueTail() {
        MarkdownToken token = this.tokenQueue.peekLast();
        boolean removedToken = false;
        while (token != null && Objects.equals(token.getContent(), this.newline) && !token.isTranslatable()) {
            this.tokenQueue.removeLast();
            token = this.tokenQueue.peekLast();
            removedToken = true;
        }
        if (removedToken) {
            this.tokenQueue.addLast(new MarkdownToken(this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK));
            this.numNonTranslatableNewlines = 1;
        } else {
            this.numNonTranslatableNewlines = 0;
        }
    }

    private void visitBlock(Block node, boolean isTranslatable, MarkdownTokenType type) {
        this.addToQueue(node.getContentChars().toString(), isTranslatable, type, node);
        this.addBlockNewlines(node);
    }

    private void addBlockNewlines(Node node) {
        this.addToQueue(this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
        this.addToQueue(this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
    }

    private void visitDelimitedNode(DelimitedNodeImpl node, MarkdownTokenType type) {
        this.addToQueue(node.getOpeningMarker().toString(), false, type, node);
        this.addToQueue(node.getText().toString(), true, MarkdownTokenType.TEXT, node);
        this.addToQueue(node.getClosingMarker().toString(), false, type, node);
    }

    private void visitHtmlBlockBase(HtmlBlockBase node, MarkdownTokenType type) {
        this.addToQueue(node.getChars().toString().trim(), true, type, node);
        this.addBlockNewlines(node);
        for (Node child : node.getChildren()) {
            this.visitor.visit(child);
            this.addBlockNewlines(child);
            this.removeDuplicateNewlinesAtQueueTail();
        }
    }

    private void visitInlineLink(InlineLinkNode node, MarkdownTokenType type) {
        StringBuilder sb = new StringBuilder();
        if (this.isDefined(node.getText())) {
            this.addToQueue(node.getTextOpeningMarker().toString(), false, type, node);
            this.addToQueue(node.getText().toString(), true, MarkdownTokenType.TEXT, node);
            sb.append(node.getTextClosingMarker());
        }
        sb.append(node.getLinkOpeningMarker());
        sb.append(node.getUrlOpeningMarker());
        if (this.params.getTranslateUrls() && this.isDefined(node.getUrl())) {
            this.addToQueue(sb.toString(), false, type, node);
            sb = new StringBuilder();
            this.addToQueue(node.getUrl().toString(), true, MarkdownTokenType.TEXT, node);
        } else {
            sb.append(node.getUrl());
        }
        sb.append(node.getUrlClosingMarker());
        if (this.isDefined(node.getTitle())) {
            sb.append(node.getTitleOpeningMarker());
            this.addToQueue(sb.toString(), false, type, node);
            this.addToQueue(node.getTitle().toString(), true, MarkdownTokenType.TEXT, node);
            sb = new StringBuilder(node.getTitleClosingMarker());
        }
        sb.append(node.getLinkClosingMarker());
        this.addToQueue(sb.toString(), false, type, node);
    }

    private void visitRefDeclaration(RefNode node, MarkdownTokenType type) {
        if (this.isDefined(node.getText())) {
            if (node instanceof ImageRef) {
                this.addToQueue("!" + node.getTextOpeningMarker().toString(), false, type, node);
            } else {
                this.addToQueue(node.getTextOpeningMarker().toString(), false, type, node);
            }
            this.addToQueue(node.getText().toString(), false, type, node);
            this.addToQueue(node.getTextClosingMarker().toString(), false, type, node);
        }
        if (this.isDefined(node.getReferenceOpeningMarker())) {
            this.addToQueue(node.getReferenceOpeningMarker().toString(), false, type, node);
        }
        if (this.isDefined(node.getReference())) {
            this.addToQueue(node.getReference().toString(), false, type, node);
        }
        if (this.isDefined(node.getReferenceClosingMarker())) {
            this.addToQueue(node.getReferenceClosingMarker().toString(), false, type, node);
        }
    }

    private void visitReferenceDefinition(Reference node, MarkdownTokenType type) {
        this.addToQueue(node.getOpeningMarker().toString(), false, type, node);
        this.addToQueue(node.getReference().toString(), false, type, node);
        this.addToQueue(node.getClosingMarker().toString() + " ", false, type, node);
        if (this.isDefined(node.getUrlOpeningMarker())) {
            this.addToQueue(node.getUrlOpeningMarker().toString(), false, type, node);
        }
        if (this.isDefined(node.getUrl())) {
            this.addToQueue(node.getUrl().toString(), false, type, node);
        }
        if (this.isDefined(node.getUrlClosingMarker())) {
            this.addToQueue(node.getUrlClosingMarker().toString(), false, type, node);
        }
        if (this.isDefined(node.getTitle())) {
            this.addToQueue(" " + node.getTitleOpeningMarker().toString(), false, type, node);
            this.addToQueue(node.getTitle().toString(), true, type, node);
            this.addToQueue(node.getTitleClosingMarker().toString(), false, type, node);
        }
        this.addToQueue(this.newline, false, type, node);
    }

    private void visitListBlock(ListBlock listBlock, MarkdownTokenType type) {
        this.visitor.visitChildren(listBlock);
        this.addBlockNewlines(listBlock);
    }

    private void visitListItem(ListItem listItem, MarkdownTokenType type) {
        ListBlock innerList = this.getParentList(listItem);
        ListItem firstItem = this.getFirstItemOfList(innerList);
        ListBlock outerList = this.getParentList(innerList);
        if (outerList != null && (listItem.isTight() || listItem == firstItem && outerList.isTight())) {
            this.removeDuplicateNewlinesAtQueueTail();
        }
        this.addToQueue(listItem.getOpeningMarker().toString() + " ", false, type, listItem);
        if (!listItem.hasChildren()) {
            this.addBlockNewlines(listItem);
        }
        this.visitor.visitChildren(listItem);
        if (listItem.isInTightList()) {
            this.removeDuplicateNewlinesAtQueueTail();
        }
    }

    private ListBlock getParentList(Node node) {
        return node == null ? null : (ListBlock)node.getAncestorOfType(BulletList.class, OrderedList.class);
    }

    private ListItem getFirstItemOfList(ListBlock node) {
        return node == null ? null : (ListItem)node.getFirstChildAny(BulletListItem.class, OrderedListItem.class);
    }

    private boolean isDefined(BasedSequence sequence) {
        return sequence != BasedSequence.NULL && !sequence.isEmpty();
    }
}

