/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.XMLEvents;

class Block
implements XMLEvents,
Textual {
    private QName runName;
    private QName textName;
    private List<Chunk> chunks;
    private boolean isHidden;

    Block(List<Chunk> chunks, QName runName, QName textName, boolean isHidden) {
        this.chunks = new ArrayList<Chunk>(chunks);
        this.runName = runName;
        this.textName = textName;
        this.isHidden = isHidden;
    }

    QName getRunName() {
        return this.runName;
    }

    QName getTextName() {
        return this.textName;
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        for (XMLEvents xMLEvents : this.chunks) {
            events.addAll(xMLEvents.getEvents());
        }
        return events;
    }

    public List<Chunk> getChunks() {
        return this.chunks;
    }

    boolean isHidden() {
        return this.isHidden;
    }

    boolean hasVisibleRunContent() {
        for (Chunk chunk : this.chunks) {
            if (!(chunk instanceof Run ? ((Run)chunk).containsVisibleText() : chunk instanceof RunContainer && ((RunContainer)chunk).containsVisibleText())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Block [" + this.chunks + "]";
    }

    static class BlockMarkup
    extends Markup
    implements BlockChunk {
        BlockMarkup() {
        }
    }

    public static interface BlockChunk
    extends Chunk {
    }
}

