/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunCode;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.UnstyledText;
import net.sf.okapi.filters.openxml.XMLEvents;

abstract class TextUnitMapper {
    private static final int DEFAULT_CODE_STACK_POPS_LIMIT = 0;
    private static final int UNUSED_RUN_POSITION_VALUE = -1;
    private static final String NESTED_ID_GENERATOR_PREFIX = "sub";
    protected IdGenerator idGenerator;
    protected List<ITextUnit> textUnits;
    protected List<ITextUnit> referentTus = new ArrayList<ITextUnit>();
    protected Map<Integer, XMLEvents> codeMap = new HashMap<Integer, XMLEvents>();
    protected Deque<RunCode> runCodeStack = new ArrayDeque<RunCode>();
    protected int nextCodeId = 1;
    protected IdGenerator nestedIdsGenerator;

    TextUnitMapper(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public abstract List<ITextUnit> getTextUnits();

    protected boolean processRun(TextFragment tf, Run run, ITextUnit textUnit) {
        this.referentTus.addAll(this.processNestedBlocks(run, textUnit.getId()));
        return this.addRun(tf, 0, -1, run, null);
    }

    protected List<ITextUnit> processNestedBlocks(Run run, String parentId) {
        IdGenerator nestedIdsGenerator = this.getNestedIdsGenerator(parentId);
        ArrayList<ITextUnit> tus = new ArrayList<ITextUnit>();
        for (Textual textual : run.getNestedTextualItems()) {
            if (!(textual instanceof UnstyledText)) continue;
            TextUnit tu = new TextUnit(nestedIdsGenerator.createId(), ((UnstyledText)textual).getText());
            tu.setPreserveWhitespaces(true);
            tus.add(tu);
        }
        for (ITextUnit tu : tus) {
            tu.setIsReferent(true);
        }
        return tus;
    }

    private IdGenerator getNestedIdsGenerator(String parentId) {
        if (this.nestedIdsGenerator == null) {
            this.nestedIdsGenerator = new IdGenerator(parentId, NESTED_ID_GENERATOR_PREFIX);
        }
        return this.nestedIdsGenerator;
    }

    protected boolean addRun(TextFragment tf, int codeStackPopsLimit, int runPosition, Run run, Run nextRun) {
        if (!run.containsVisibleText()) {
            this.addIsolatedCode(tf, run);
            return false;
        }
        RunProperties rp = run.getProperties();
        while (this.runCodeStack.size() > codeStackPopsLimit && !this.runCodeStack.isEmpty() && !this.runCodeStack.peekFirst().getRunProperties().isSubsetOf(rp)) {
            this.addClosingCode(tf, this.runCodeStack.pop());
        }
        if (0 == runPosition && null != nextRun && !nextRun.getProperties().equals(rp) && !nextRun.getProperties().isSubsetOf(rp) || (0 < runPosition || 0 < rp.count()) && (this.runCodeStack.isEmpty() || !this.runCodeStack.peekFirst().getRunProperties().equals(rp))) {
            RunCode rc = new RunCode(this.nextCodeId++, rp, run.getCombinedProperties());
            this.runCodeStack.push(rc);
            this.addOpeningCode(tf, rc);
        }
        this.addRunContent(tf, run);
        return true;
    }

    protected void addRunContent(TextFragment tf, Run run) {
        for (XMLEvents xMLEvents : run.getBodyChunks()) {
            if (xMLEvents instanceof Run.RunText) {
                this.addText(tf, ((Run.RunText)xMLEvents).getText());
                continue;
            }
            this.addIsolatedCode(tf, xMLEvents);
        }
    }

    protected void popAllRunCodes(TextFragment tf) {
        while (!this.runCodeStack.isEmpty()) {
            this.addClosingCode(tf, this.runCodeStack.pop());
        }
    }

    protected void addText(TextFragment tf, String text) {
        tf.append(text);
    }

    protected void addOpeningCode(TextFragment tf, RunCode rc) {
        Code code = new Code(TextFragment.TagType.OPENING, rc.getCodeType());
        code.setId(rc.getCodeId());
        code.setData("<run" + code.getId() + ">");
        this.codeMap.put(rc.getCodeId(), rc.getRunProperties());
        tf.append(code);
    }

    protected void addClosingCode(TextFragment tf, RunCode rc) {
        Code code = new Code(TextFragment.TagType.CLOSING, rc.getCodeType());
        code.setId(rc.getCodeId());
        code.setData("</run" + code.getId() + ">");
        tf.append(code);
    }

    protected void addIsolatedCode(TextFragment tf, XMLEvents events) {
        int codeId = this.nextCodeId++;
        this.codeMap.put(codeId, events);
        Code code = new Code(TextFragment.TagType.PLACEHOLDER, "x", this.getCodeData(events, codeId));
        code.setId(codeId);
        tf.append(code);
    }

    private String getCodeData(XMLEvents codeEvents, int codeId) {
        if (codeEvents instanceof Run) {
            return "<run" + codeId + "/>";
        }
        return "<tags" + codeId + "/>";
    }
}

