/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.MasterAndPagePartHandler;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.NonTranslatablePartHandler;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class VisioDocument
extends DocumentType {
    private static final String MASTERS = Namespaces.VisioDocumentRelationships.getDerivedURI("/masters");
    private static final String PAGES = Namespaces.VisioDocumentRelationships.getDerivedURI("/pages");
    private static final String MASTER = Namespaces.VisioDocumentRelationships.getDerivedURI("/master");
    private static final String PAGE = Namespaces.VisioDocumentRelationships.getDerivedURI("/page");
    private List<String> mastersAndPages;

    VisioDocument(OpenXMLZipFile zipFile, ConditionalParameters params) {
        super(zipFile, params);
    }

    @Override
    boolean isClarifiablePart(String contentType) {
        return false;
    }

    @Override
    boolean isStyledTextPart(String entryName, String type) {
        return false;
    }

    @Override
    void initialize() throws IOException, XMLStreamException {
        this.mastersAndPages = this.getMastersAndPages();
    }

    private List<String> getMastersAndPages() throws IOException, XMLStreamException {
        String mainDocumentPart = this.getZipFile().getMainDocumentTarget();
        Relationships relationships = this.getZipFile().getRelationshipsForTarget(mainDocumentPart);
        List<Relationships.Rel> masters = relationships.getRelByType(MASTERS);
        if (masters == null || masters.size() != 1) {
            throw new OkapiBadFilterInputException("Unexpected number of relationships");
        }
        List<Relationships.Rel> pages = relationships.getRelByType(PAGES);
        if (pages == null || pages.size() != 1) {
            throw new OkapiBadFilterInputException("Unexpected number of relationships");
        }
        Relationships masterRelationships = this.getZipFile().getRelationshipsForTarget(masters.get((int)0).target);
        Relationships pageRelationships = this.getZipFile().getRelationshipsForTarget(pages.get((int)0).target);
        List<String> targets = Relationships.mapRelsToTargets(masterRelationships.getRelByType(MASTER));
        targets.addAll(Relationships.mapRelsToTargets(pageRelationships.getRelByType(PAGE)));
        return targets;
    }

    @Override
    OpenXMLPartHandler getHandlerForFile(ZipEntry entry, String contentType) {
        if (!this.isTranslatableType(entry.getName(), contentType)) {
            return new NonTranslatablePartHandler(this.getZipFile(), entry);
        }
        return new MasterAndPagePartHandler(this.getParams(), this.getZipFile(), entry);
    }

    private boolean isTranslatableType(String entryName, String contentType) {
        return entryName.endsWith(".xml") && (VisioDocument.isMasterPart(contentType) || VisioDocument.isPagePart(contentType));
    }

    @Override
    Enumeration<? extends ZipEntry> getZipFileEntries() throws IOException, XMLStreamException {
        ArrayList<? extends ZipEntry> entryList = Collections.list(this.getZipFile().entries());
        Collections.sort(entryList, new ZipEntryComparator(this.mastersAndPages));
        return Collections.enumeration(entryList);
    }
}

