/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.NonTranslatablePartHandler;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.RelationshipsPartHandler;
import net.sf.okapi.filters.openxml.StandardPartHandler;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyledTextPartHandler;
import net.sf.okapi.filters.openxml.WordProcessingStylesParser;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class WordDocument
extends DocumentType {
    private static final String STYLE_DEFINITIONS_SOURCE_TYPE = Namespaces.DocumentRelationships.getDerivedURI("/styles");
    private static final String TARGET_REL_FILE = "document.xml.rels";

    WordDocument(OpenXMLZipFile zipFile, ConditionalParameters params) {
        super(zipFile, params);
    }

    @Override
    void initialize() throws IOException, XMLStreamException {
        this.setStyleDefinitions(this.parseStyleDefinitions());
    }

    private StyleDefinitions parseStyleDefinitions() throws IOException, XMLStreamException {
        String relationshipTarget = this.getRelationshipTarget();
        if (null == relationshipTarget) {
            return StyleDefinitions.emptyStyleDefinitions();
        }
        Reader reader = this.getZipFile().getPartReader(relationshipTarget);
        return new WordProcessingStylesParser(this.getZipFile().getEventFactory(), this.getZipFile().getInputFactory(), reader, this.getParams()).parse();
    }

    private String getRelationshipTarget() throws IOException, XMLStreamException {
        String mainDocumentTarget = this.getZipFile().getMainDocumentTarget();
        Relationships relationships = this.getZipFile().getRelationshipsForTarget(mainDocumentTarget);
        List<Relationships.Rel> rels = relationships.getRelByType(STYLE_DEFINITIONS_SOURCE_TYPE);
        if (null == rels) {
            return null;
        }
        return rels.get((int)0).target;
    }

    @Override
    OpenXMLPartHandler getHandlerForFile(ZipEntry entry, String contentType) {
        if ("application/vnd.openxmlformats-package.relationships+xml".equals(contentType) && entry.getName().endsWith(TARGET_REL_FILE) && this.getParams().getExtractExternalHyperlinks()) {
            return new RelationshipsPartHandler(this.getParams(), this.getZipFile(), entry);
        }
        if (!this.isTranslatableType(entry.getName(), contentType)) {
            return new NonTranslatablePartHandler(this.getZipFile(), entry);
        }
        if (this.isStyledTextPart(entry.getName(), contentType)) {
            return new StyledTextPartHandler(this.getParams(), this.getZipFile(), entry, this.getStyleDefinitions());
        }
        OpenXMLContentFilter openXMLContentFilter = new OpenXMLContentFilter(this.getParams());
        openXMLContentFilter.setPartName(entry.getName());
        ParseType parseType = ParseType.MSWORD;
        if ("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml".equals(contentType)) {
            openXMLContentFilter.setBInSettingsFile(true);
        } else if ("application/vnd.openxmlformats-officedocument.drawingml.chart+xml".equals(contentType)) {
            parseType = ParseType.MSWORDCHART;
        } else if ("application/vnd.openxmlformats-package.core-properties+xml".equals(contentType)) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        }
        openXMLContentFilter.setUpConfig(parseType);
        if (null != this.getParams().tsExcludeWordStyles && !this.getParams().tsExcludeWordStyles.isEmpty()) {
            openXMLContentFilter.setTsExcludeWordStyles(this.getParams().tsExcludeWordStyles);
        }
        return new StandardPartHandler(openXMLContentFilter, this.getParams(), this.getZipFile(), entry);
    }

    @Override
    boolean isClarifiablePart(String contentType) {
        return false;
    }

    @Override
    boolean isStyledTextPart(String entryName, String type) {
        return type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml") || type.equals("application/vnd.ms-word.document.macroEnabled.main+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml") || type.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml");
    }

    private boolean isTranslatableType(String entryName, String type) {
        if (!entryName.endsWith(".xml")) {
            return false;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml")) {
            return true;
        }
        if (type.equals("application/vnd.ms-word.document.macroEnabled.main+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml")) {
            return true;
        }
        if (this.getParams().getTranslateDocProperties() && type.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml")) {
            return this.getParams().getTranslateWordHeadersFooters();
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml")) {
            return this.getParams().getTranslateComments();
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.chart+xml")) {
            return true;
        }
        return this.isStyledTextPart(entryName, type);
    }

    @Override
    Enumeration<? extends ZipEntry> getZipFileEntries() {
        ArrayList<? extends ZipEntry> list = Collections.list(this.getZipFile().entries());
        ArrayList<String> additionalParts = new ArrayList<String>();
        additionalParts.add("word/styles.xml");
        additionalParts.add("word/_rels/document.xml.rels");
        additionalParts.add("word/document.xml");
        Collections.sort(list, new ZipEntryComparator(additionalParts));
        return Collections.enumeration(list);
    }
}

