/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.XMLEventSerializer;
import net.sf.okapi.filters.openxml.XMLEvents;

class XMLEventHelpers {
    static final QName ATTR_XML_SPACE = Namespaces.XML.getQName("space");
    static final QName CACHED_PAGE_BREAK = Namespaces.WordProcessingML.getQName("lastRenderedPageBreak");
    static final QName WPML_ID = Namespaces.WordProcessingML.getQName("id");
    static final QName WPML_NAME = Namespaces.WordProcessingML.getQName("name");
    static final QName WPML_VAL = Namespaces.WordProcessingML.getQName("val");
    static final QName WPML_PROPERTY_VANISH = Namespaces.WordProcessingML.getQName("vanish");
    static final QName RUN_STYLE = Namespaces.WordProcessingML.getQName("rStyle");
    static final QName PARAGRAPH_STYLE = Namespaces.WordProcessingML.getQName("pStyle");
    static final String LOCAL_SHEET_VIEW = "sheetView";
    static final String LOCAL_ALIGNMENT = "alignment";
    static final String LOCAL_PRESENTATION = "presentation";
    static final String LOCAL_TABLE = "tbl";
    static final String LOCAL_TABLE_PROPERTIES = "tblPr";
    static final String LOCAL_TABLE_GRID = "tblGrid";
    static final String LOCAL_TABLE_ROW = "tr";
    static final String LOCAL_TEXT_BODY = "txBody";
    static final String LOCAL_TEXT_BODY_PROPERTIES = "bodyPr";
    static final String LOCAL_PARA = "p";
    static final String LOCAL_STRING_ITEM = "si";
    static final String LOCAL_PARAGRAPH_PROPERTIES = "pPr";
    static final String LOCAL_BIDIRECTIONAL = "bidi";
    static final String LOCAL_BIDI_VISUAL = "bidiVisual";
    static final String LOCAL_RTL = "rtl";
    static final String LOCAL_RTL_COL = "rtlCol";
    static final String LOCAL_READING_ORDER = "readingOrder";
    static final String LOCAL_RIGHT_TO_LEFT = "rightToLeft";
    static final String LOCAL_RUN = "r";
    static final String LOCAL_RUN_PROPERTIES = "rPr";
    static final String LOCAL_PROPERTY_LANGUAGE = "lang";
    static final String LOCAL_TEXT = "t";
    static final String LOCAL_NO_BREAK_HYPHEN = "noBreakHyphen";
    static final String LOCAL_REGULAR_HYPHEN_VALUE = "-";
    static final String LOCAL_SOFT_HYPHEN = "softHyphen";
    static final String LOCAL_TAB = "tab";
    static final String LOCAL_BREAK = "br";
    static final String LOCAL_CARRIAGE_RETURN = "cr";
    static final String LOCAL_SECTION_PROPERTIES = "sectPr";
    static final String LOCAL_TEXTPATH = "textpath";
    static final String LOCAL_DRAWING_PROPERTY = "docPr";
    static final String LOCAL_GRAPHICS_PROPERTY = "cNvPr";
    static final String LOCAL_SIMPLE_FIELD = "fldSimple";
    static final String LOCAL_COMPLEX_FIELD = "fldChar";
    static final String LOCAL_SMART_TAG_PROPERTIES = "smartTagPr";
    static final String LOCAL_FIELD_CODE = "instrText";
    static final QName COMPLEX_FIELD_TYPE = Namespaces.WordProcessingML.getQName("fldCharType");
    static final String LOCAL_TYPE = "type";
    static final String PREFIX_A = "a";
    private static final String LOCAL_TABLE_COLUMN = "tableColumn";
    private static final String LOCAL_SHEET_FORMULA = "f";
    private static final String LOCAL_TABLE_FORMULA = "formula";
    private static final String LOCAL_CALCULATED_FORMULA = "calculatedColumnFormula";
    static final EnumSet<BooleanAttributeValue> BOOLEAN_ATTRIBUTE_TRUE_VALUES = EnumSet.of(BooleanAttributeValue.TRUE_INTEGER, BooleanAttributeValue.TRUE_STRING);
    static final boolean DEFAULT_BOOLEAN_ATTRIBUTE_TRUE_VALUE = Boolean.valueOf(BooleanAttributeValue.TRUE_STRING.getValue());
    static final boolean DEFAULT_BOOLEAN_ATTRIBUTE_FALSE_VALUE = Boolean.valueOf(BooleanAttributeValue.FALSE_STRING.getValue());

    XMLEventHelpers() {
    }

    static boolean isSectionPropertiesStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_SECTION_PROPERTIES);
    }

    static boolean isSheetViewStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_SHEET_VIEW);
    }

    static boolean isSheetViewEndEvent(XMLEvent event) {
        return XMLEventHelpers.isEndElement(event, LOCAL_SHEET_VIEW);
    }

    static boolean isAlignmentStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_ALIGNMENT);
    }

    static boolean isPresentationStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_PRESENTATION);
    }

    static boolean isPresentationEndEvent(XMLEvent event) {
        return XMLEventHelpers.isEndElement(event, LOCAL_PRESENTATION);
    }

    static boolean isBlockMarkupStartEvent(XMLEvent event) {
        return XMLEventHelpers.isTableStartEvent(event) || XMLEventHelpers.isTextBodyStartEvent(event);
    }

    static boolean isBlockMarkupEndEvent(XMLEvent event) {
        return XMLEventHelpers.isTableEndEvent(event) || XMLEventHelpers.isTextBodyEndEvent(event);
    }

    static boolean isTableStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_TABLE);
    }

    static boolean isTableEndEvent(XMLEvent event) {
        return XMLEventHelpers.isEndElement(event, LOCAL_TABLE);
    }

    static boolean isTablePropertiesStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_TABLE_PROPERTIES);
    }

    static boolean isTableGridStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_TABLE_GRID);
    }

    static boolean isTableGridEndEvent(XMLEvent event) {
        return XMLEventHelpers.isEndElement(event, LOCAL_TABLE_GRID);
    }

    static boolean isTableRowStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_TABLE_ROW);
    }

    static boolean isTextBodyStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_TEXT_BODY);
    }

    static boolean isTextBodyEndEvent(XMLEvent event) {
        return XMLEventHelpers.isEndElement(event, LOCAL_TEXT_BODY);
    }

    static boolean isTextBodyPropertiesStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_TEXT_BODY_PROPERTIES);
    }

    static boolean isParagraphStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_PARA);
    }

    static boolean isStringItemStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_STRING_ITEM);
    }

    static boolean isStringItemEndEvent(XMLEvent e) {
        return XMLEventHelpers.isEndElement(e, LOCAL_STRING_ITEM);
    }

    static boolean isParagraphPropertiesStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_PARAGRAPH_PROPERTIES);
    }

    static boolean isRunStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_RUN) && !Namespaces.Math.containsName(e.asStartElement().getName());
    }

    static boolean isRunContainerStartEvent(XMLEvent e) {
        return e.isStartElement() && RunContainer.RUN_CONTAINER_TYPES.contains((Object)RunContainer.Type.fromValue(e.asStartElement().getName().getLocalPart()));
    }

    static boolean isSimpleFieldStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_SIMPLE_FIELD);
    }

    static boolean isRunPropsStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_RUN_PROPERTIES);
    }

    static boolean isRunContainerPropertiesStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_SMART_TAG_PROPERTIES);
    }

    static boolean isTextStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_TEXT);
    }

    static boolean isTableColumnEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_TABLE_COLUMN);
    }

    static boolean isExcelFormula(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_SHEET_FORMULA) || XMLEventHelpers.isStartElement(e, LOCAL_TABLE_FORMULA) || XMLEventHelpers.isStartElement(e, LOCAL_CALCULATED_FORMULA);
    }

    static boolean isNoBreakHyphenStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_NO_BREAK_HYPHEN);
    }

    static boolean isSoftHyphenStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_SOFT_HYPHEN);
    }

    static boolean isTabStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_TAB);
    }

    static boolean isLineBreakStartEvent(XMLEvent e) {
        if (XMLEventHelpers.isStartElement(e, LOCAL_BREAK) || XMLEventHelpers.isStartElement(e, LOCAL_CARRIAGE_RETURN)) {
            QName typeName;
            StartElement start = e.asStartElement();
            Attribute a = start.getAttributeByName(typeName = XMLEventHelpers.createQName(LOCAL_TYPE, start.getName()));
            if (a == null) {
                return true;
            }
            String type = a.getValue();
            if (!type.equals("page") && !type.equals("column")) {
                return true;
            }
        }
        return false;
    }

    static boolean isPageBreak(StartElement startElement) {
        QName name = startElement.getName();
        if (!LOCAL_BREAK.equals(name.getLocalPart())) {
            return false;
        }
        QName typeName = new QName(name.getNamespaceURI(), LOCAL_TYPE);
        return "page".equals(XMLEventHelpers.getAttributeValue(startElement, typeName));
    }

    static boolean isTextPath(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_TEXTPATH);
    }

    static boolean isGraphicsProperty(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_DRAWING_PROPERTY) || XMLEventHelpers.isStartElement(e, LOCAL_GRAPHICS_PROPERTY);
    }

    static boolean isComplexCodeStart(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_COMPLEX_FIELD) && "begin".equals(XMLEventHelpers.getAttributeValue(e.asStartElement(), COMPLEX_FIELD_TYPE));
    }

    static boolean isComplexCodeSeparate(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_COMPLEX_FIELD) && "separate".equals(XMLEventHelpers.getAttributeValue(e.asStartElement(), COMPLEX_FIELD_TYPE));
    }

    static boolean isComplexCodeEnd(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_COMPLEX_FIELD) && "end".equals(XMLEventHelpers.getAttributeValue(e.asStartElement(), COMPLEX_FIELD_TYPE));
    }

    static boolean isFieldCodeStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_FIELD_CODE);
    }

    static boolean isFieldCodeEndEvent(XMLEvent e) {
        return XMLEventHelpers.isEndElement(e, LOCAL_FIELD_CODE);
    }

    static boolean isStartElement(XMLEvent e, String expectedLocalPart) {
        return e.isStartElement() && expectedLocalPart.equals(e.asStartElement().getName().getLocalPart());
    }

    static boolean isEndElement(XMLEvent e, StartElement correspondingStartElement) {
        return e.isEndElement() && e.asEndElement().getName().equals(correspondingStartElement.getName());
    }

    static boolean isEndElement(XMLEvent e, String expectedLocalPart) {
        return e.isEndElement() && expectedLocalPart.equals(e.asEndElement().getName().getLocalPart());
    }

    static boolean hasPreserveWhitespace(StartElement e) {
        return "preserve".equals(XMLEventHelpers.getAttributeValue(e, ATTR_XML_SPACE));
    }

    static boolean isWhitespace(XMLEvent e) {
        return e.isCharacters() && e.asCharacters().getData().trim().isEmpty();
    }

    static String getAttributeValue(StartElement el, QName name) {
        Attribute attr = el.getAttributeByName(name);
        return attr != null ? attr.getValue() : null;
    }

    static boolean getBooleanAttributeValue(StartElement element, QName name, boolean defaultValue) {
        Attribute attribute = element.getAttributeByName(name);
        if (null == attribute) {
            return defaultValue;
        }
        return BOOLEAN_ATTRIBUTE_TRUE_VALUES.contains((Object)BooleanAttributeValue.fromValue(attribute.getValue()));
    }

    static QName createQName(String localPart, QName modelName) {
        return new QName(modelName.getNamespaceURI(), localPart, modelName.getPrefix());
    }

    static List<XMLEvent> gatherEvents(StartElementContext startElementContext) throws XMLStreamException {
        ArrayList<XMLEvent> p = new ArrayList<XMLEvent>();
        p.add(startElementContext.getStartElement());
        while (startElementContext.getEventReader().hasNext()) {
            XMLEvent e = startElementContext.getEventReader().nextEvent();
            p.add(e);
            if (!XMLEventHelpers.isEndElement(e, startElementContext.getStartElement())) continue;
            return p;
        }
        throw new IllegalStateException("Unterminated start element: " + XMLEventSerializer.serialize(startElementContext.getStartElement()));
    }

    static boolean eventEquals(List<XMLEvent> e1, List<XMLEvent> e2) {
        if (e1.size() != e2.size()) {
            return false;
        }
        for (int i = 0; i < e1.size(); ++i) {
            if (XMLEventHelpers.eventEquals(e1.get(i), e2.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean eventEquals(XMLEvent e1, XMLEvent e2) {
        if (e1.getEventType() != e2.getEventType()) {
            return false;
        }
        switch (e1.getEventType()) {
            case 1: {
                return XMLEventHelpers.startElementEquals(e1.asStartElement(), e2.asStartElement());
            }
            case 2: {
                return e1.asEndElement().getName().equals(e2.asEndElement().getName());
            }
            case 4: {
                return e1.asCharacters().getData().equals(e2.asCharacters().getData());
            }
        }
        return true;
    }

    static boolean startElementEquals(StartElement e1, StartElement e2) {
        return e1.getName().equals(e2.getName()) && XMLEventHelpers.attrEquals(e1, e2);
    }

    static boolean attrEquals(StartElement e1, StartElement e2) {
        List<Attribute> a1 = XMLEventHelpers.attributesToList(e1);
        List<Attribute> a2 = XMLEventHelpers.attributesToList(e2);
        if (a1.size() != a2.size()) {
            return false;
        }
        for (Attribute a : a1) {
            boolean foundMatch = false;
            for (Attribute test : a2) {
                if (!XMLEventHelpers.attrEquals(a, test)) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    static List<Attribute> attributesToList(StartElement el) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        Iterator<Attribute> it = el.getAttributes();
        while (it.hasNext()) {
            attrs.add(it.next());
        }
        return attrs;
    }

    static boolean attrEquals(Attribute a1, Attribute a2) {
        return Objects.equals(a1.getName(), a2.getName()) && Objects.equals(a1.getValue(), a2.getValue());
    }

    static void addChunksToList(List<XMLEvent> list, List<Chunk> chunks) {
        for (XMLEvents xMLEvents : chunks) {
            list.addAll(xMLEvents.getEvents());
        }
    }

    static enum BooleanAttributeValue {
        INVALID_VALUE(""),
        FALSE_INTEGER("0"),
        TRUE_INTEGER("1"),
        FALSE_STRING("false"),
        TRUE_STRING("true");

        String value;

        private BooleanAttributeValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static BooleanAttributeValue fromValue(String value) {
            if (null == value) {
                return INVALID_VALUE;
            }
            for (BooleanAttributeValue attributeValue : BooleanAttributeValue.values()) {
                if (!value.equals(attributeValue.getValue())) continue;
                return attributeValue;
            }
            return INVALID_VALUE;
        }
    }
}

