/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.XLIFFTool;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.beans.v1.TextUnitBean;
import net.sf.okapi.lib.beans.v1.XLIFFToolBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;

public class AltTranslationBean
extends PersistenceBean<AltTranslation> {
    private String srcLocId;
    private String trgLocId;
    private TextUnitBean tu = new TextUnitBean();
    private MatchType type;
    private int score;
    private String origin;
    private int fuzzyScore;
    private int qualityScore;
    private boolean fromOriginal;
    private String engine;
    private XLIFFToolBean tool = new XLIFFToolBean();

    @Override
    protected AltTranslation createObject(IPersistenceSession session) {
        ITextUnit tunit = this.tu.get(ITextUnit.class, session);
        LocaleId srcLoc = null;
        LocaleId trgLoc = null;
        if (!Util.isEmpty(this.srcLocId)) {
            srcLoc = LocaleId.fromString(this.srcLocId);
        }
        if (!Util.isEmpty(this.trgLocId)) {
            trgLoc = LocaleId.fromString(this.trgLocId);
        }
        TextFragment src = null;
        TextFragment trg = null;
        if (tunit != null) {
            src = tunit.getSource().getSegments().getFirstContent();
            trg = tunit.getTarget(trgLoc).getSegments().getFirstContent();
        }
        return new AltTranslation(srcLoc, trgLoc, null, src, trg, this.type, this.score, this.origin);
    }

    @Override
    protected void fromObject(AltTranslation obj, IPersistenceSession session) {
        this.srcLocId = obj.getSourceLocale().toString();
        this.trgLocId = obj.getTargetLocale().toString();
        this.tu.set(obj.getEntry(), session);
        this.type = obj.getType();
        this.score = obj.getCombinedScore();
        this.origin = obj.getOrigin();
        this.fuzzyScore = obj.getFuzzyScore();
        this.qualityScore = obj.getQualityScore();
        this.fromOriginal = obj.getFromOriginal();
        this.engine = obj.getEngine();
        this.tool.set(obj.getTool(), session);
    }

    @Override
    protected void setObject(AltTranslation obj, IPersistenceSession session) {
        obj.setFuzzyScore(this.fuzzyScore);
        obj.setQualityScore(this.qualityScore);
        obj.setFromOriginal(this.fromOriginal);
        obj.setEngine(this.engine);
        obj.setTool(this.tool.get(XLIFFTool.class, session));
    }

    public String getSrcLocId() {
        return this.srcLocId;
    }

    public void setSrcLocId(String srcLocId) {
        this.srcLocId = srcLocId;
    }

    public String getTrgLocId() {
        return this.trgLocId;
    }

    public void setTrgLocId(String trgLocId) {
        this.trgLocId = trgLocId;
    }

    public TextUnitBean getTu() {
        return this.tu;
    }

    public void setTu(TextUnitBean tu) {
        this.tu = tu;
    }

    public MatchType getType() {
        return this.type;
    }

    public void setType(MatchType type) {
        this.type = type;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public int getFuzzyScore() {
        return this.fuzzyScore;
    }

    public void setFuzzyScore(int fuzzyScore) {
        this.fuzzyScore = fuzzyScore;
    }

    public int getQualityScore() {
        return this.qualityScore;
    }

    public void setQualityScore(int qualityScore) {
        this.qualityScore = qualityScore;
    }

    public boolean isFromOriginal() {
        return this.fromOriginal;
    }

    public void setFromOriginal(boolean fromOriginal) {
        this.fromOriginal = fromOriginal;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public XLIFFToolBean getTool() {
        return this.tool;
    }

    public void setTool(XLIFFToolBean tool) {
        this.tool = tool;
    }
}

