/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.tkit.jarswitcher;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import net.sf.okapi.common.FileUtil;

public class VMClassLoader
extends URLClassLoader {
    private String appRootName;
    private Class<?> appRoot;
    String offset = "";

    public VMClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        DataInputStream dis = new DataInputStream(System.in);
        try {
            String path = dis.readUTF();
            this.addURL(FileUtil.fileToUrl(new File(path)));
            System.out.println(path);
            this.appRootName = dis.readUTF();
            System.out.println("appRootName: " + this.appRootName);
            final URL origClassURL = FileUtil.fileToUrl(new File(dis.readUTF()));
            System.out.println("Orig Class URL: " + origClassURL);
            final URL classURL = FileUtil.fileToUrl(new File(dis.readUTF()));
            System.out.println("class URL: " + classURL);
            AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Class<?> run() throws ClassNotFoundException {
                    Class clazz;
                    URLConnection connection = classURL.openConnection();
                    InputStream input = connection.getInputStream();
                    try {
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        int data = input.read();
                        while (data != -1) {
                            buffer.write(data);
                            data = input.read();
                        }
                        byte[] classData = buffer.toByteArray();
                        VMClassLoader.this.appRoot = VMClassLoader.this.defineClass(VMClassLoader.this.appRootName, classData, 0, classData.length, new ProtectionDomain(new CodeSource(origClassURL, (Certificate[])null), null));
                        clazz = VMClassLoader.this.appRoot;
                    }
                    catch (Throwable throwable) {
                        try {
                            input.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(VMClassLoader.this.appRootName, e);
                        }
                    }
                    input.close();
                    return clazz;
                }
            }, AccessController.getContext());
        }
        catch (Exception e) {
            this.appRootName = null;
            this.appRoot = null;
        }
    }

    public VMClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public VMClassLoader(URL[] urls) {
        super(urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            System.out.println(this.offset + "loading " + name);
            this.offset = this.offset + " ";
            if (this.appRootName != null && this.appRoot != null && name.equals(this.appRootName)) {
                System.out.println(this.offset + "      !!! loaded self: " + this.appRootName);
                this.offset = this.offset.substring(0, this.offset.length() - 1);
                return this.appRoot;
            }
            Class<?> cls = null;
            try {
                cls = this.findClass(name);
                if (cls != null) {
                    System.out.println(this.offset + "      found itself");
                }
            }
            catch (Exception e) {
                System.out.println(this.offset + "      exception");
                cls = null;
            }
            if (cls == null && this.getParent() != null) {
                System.out.println(this.offset + "      loaded by parent");
                cls = this.getParent().loadClass(name);
            }
            if (cls == null) {
                System.out.println(this.offset + "      !!! still null");
            }
            this.offset = this.offset.substring(0, this.offset.length() - 1);
            return cls;
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }
}

