/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.repetitionanalysis;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String FUZZYTHRESHOLD = "fuzzyThreshold";
    private static final String MAXHITS = "maxHits";

    @Override
    public void reset() {
        super.reset();
        this.setFuzzyThreshold(100);
        this.setMaxHits(20);
    }

    public void setFuzzyThreshold(int fuzzyThreshold) {
        this.setInteger(FUZZYTHRESHOLD, fuzzyThreshold);
    }

    public int getFuzzyThreshold() {
        return this.getInteger(FUZZYTHRESHOLD);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(FUZZYTHRESHOLD, "Fuzzy threshold (1-100)", "Fuzzy threshold for fuzzy repetitions. Leave 100 for exact repetitions only.");
        desc.add(MAXHITS, "Max hits", "Maximum number of exact and fuzzy repetitions to keep track of for every segment.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Repetition Analysis");
        SpinInputPart sip = desc.addSpinInputPart(paramDesc.get(FUZZYTHRESHOLD));
        SpinInputPart sip2 = desc.addSpinInputPart(paramDesc.get(MAXHITS));
        sip.setRange(1, 100);
        sip2.setRange(1, 100);
        return desc;
    }

    public int getMaxHits() {
        return this.getInteger(MAXHITS);
    }

    public void setMaxHits(int maxHits) {
        this.setInteger(MAXHITS, maxHits);
    }
}

