/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.DataWithExtAttributes;

public class Note
extends DataWithExtAttributes {
    private String id;
    private String content;
    private AppliesTo appliesTo = AppliesTo.UNDEFINED;
    private int priority = 1;
    private String category;

    public Note() {
    }

    public Note(Note original) {
        super(original);
        this.id = original.id;
        this.content = original.content;
        this.appliesTo = original.appliesTo;
        this.priority = original.priority;
        this.category = original.category;
    }

    public Note(String content) {
        this(content, AppliesTo.UNDEFINED);
    }

    public Note(String content, AppliesTo appliesTo) {
        this.content = content;
        this.appliesTo = appliesTo;
    }

    public String toString() {
        return this.content;
    }

    public String getText() {
        return this.content;
    }

    public void setText(String content) {
        this.content = content;
    }

    public boolean isEmpty() {
        return Util.isNoE(this.content);
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(AppliesTo appliesTo) {
        this.appliesTo = appliesTo;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new InvalidParameterException("Invalid priority value. It must be between 1 and 10.");
        }
        this.priority = priority;
    }

    public static enum AppliesTo {
        UNDEFINED,
        SOURCE,
        TARGET;

    }
}

