/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.its.DataCategory;
import net.sf.okapi.lib.xliff2.its.IITSItem;

public class MTConfidence
extends DataCategory {
    private Double mtConfidence;

    public MTConfidence() {
    }

    public MTConfidence(String annotatorRef, double mtConfidence) {
        this.setAnnotatorRef(annotatorRef);
        this.setMtConfidence(mtConfidence);
    }

    @Override
    public String getDataCategoryName() {
        return "mt-confidence";
    }

    @Override
    public void validate() {
        if (this.mtConfidence != null && this.getAnnotatorRef() == null) {
            throw new XLIFFException("An annotator reference must be defined when mtConfidence is defined.");
        }
    }

    public Double getMtConfidence() {
        return this.mtConfidence;
    }

    public void setMtConfidence(Double mtConfidence) {
        if (mtConfidence != null && (mtConfidence < 0.0 || mtConfidence > 1.0)) {
            throw new InvalidParameterException(String.format("The mtConfidence value '%f' is out of the [0.0 to 1.0] range.", mtConfidence));
        }
        this.mtConfidence = mtConfidence;
    }

    @Override
    public IITSItem createCopy() {
        return new MTConfidence(this.getAnnotatorRef(), this.mtConfidence);
    }
}

