/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.ITSItems;

public class TermTag
extends MTag {
    public static final String TYPE_TERM = "term";
    public static final String TYPE_ITSTERMNO = "its:term-no";
    private String annotatorRef;
    private Double termConfidence;

    public TermTag(TermTag original) {
        super(original);
        this.annotatorRef = original.annotatorRef;
        this.termConfidence = original.termConfidence;
    }

    public TermTag(String id) {
        super(id, TYPE_TERM);
    }

    public TermTag(MTag tag, String type, AnnotatorsRef ar) {
        super(tag, null);
        if (tag.getTagType() != TagType.OPENING) {
            throw new InvalidParameterException("the original tag must be an opening tag.");
        }
        this.setType(type);
        this.setAnnotatorRef(ar);
    }

    public String getDataCategoryName() {
        return "terminology";
    }

    public void validate() {
        if (this.termConfidence != null && this.getAnnotatorRef() == null) {
            throw new XLIFFException("An annotator reference must be defined when termConfidence is defined.");
        }
    }

    @Override
    public void setType(String type) {
        if (type == null) {
            super.setType(TYPE_TERM);
        } else {
            if (!type.equals(TYPE_TERM) && !type.equals(TYPE_ITSTERMNO)) {
                throw new InvalidParameterException("Type must be 'term' or 'its:term-no'");
            }
            super.setType(type);
        }
    }

    public boolean isTerm() {
        return super.getType().equals(TYPE_TERM);
    }

    public void setTerm(boolean term) {
        if (term) {
            super.setType(TYPE_TERM);
        } else {
            super.setType(TYPE_ITSTERMNO);
        }
    }

    public Double getTermConfidence() {
        return this.termConfidence;
    }

    public void setTermConfidence(Double termConfidence) {
        if (termConfidence != null && (termConfidence < 0.0 || termConfidence > 1.0)) {
            throw new InvalidParameterException(String.format("The termConfidence value '%f' is out of the [0.0 to 1.0] range.", termConfidence));
        }
        this.termConfidence = termConfidence;
    }

    @Override
    public boolean hasITSItem() {
        return false;
    }

    @Override
    public ITSItems getITSItems() {
        return null;
    }

    @Override
    public void setITSItems(ITSItems itsItems) {
        throw new UnsupportedOperationException("Only the Terminology data category can be used on a term annotation.");
    }

    public void setAnnotatorRef(String annotatorRef) {
        this.annotatorRef = annotatorRef;
    }

    public void setAnnotatorRef(AnnotatorsRef ar) {
        if (ar == null) {
            return;
        }
        String ref = ar.get(this.getDataCategoryName());
        if (ref != null) {
            this.annotatorRef = ref;
        }
    }

    public String getAnnotatorRef() {
        return this.annotatorRef;
    }

    public String getTermInfo() {
        return this.getValue();
    }

    public void setTermInfo(String termInfo) {
        this.setValue(termInfo);
        this.setRef(null);
    }

    public String getTermInfoRef() {
        return this.getRef();
    }

    public void setTermInfoRef(String termInfoRef) {
        this.setRef(termInfoRef);
        this.setValue(null);
    }
}

