/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.matches;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.ExtElements;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtElements;
import net.sf.okapi.lib.xliff2.core.IWithMetadata;
import net.sf.okapi.lib.xliff2.core.IWithStore;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.metadata.Metadata;

public class Match
implements IWithExtElements,
IWithExtAttributes,
IWithMetadata,
IWithStore {
    public static final String ELEM_MTC_MATCH = "mtc:match";
    public static final String MATCH_REF_PREFIX = "#";
    public static final String DEFAULT_TYPE = "tm";
    private final Store store = new Store(this);
    private String id;
    private String type = "tm";
    private String subType;
    private Double similarity;
    private Double matchQuality;
    private Double matchSuitability;
    private String ref;
    private String origin;
    private boolean reference;
    private Fragment source;
    private Fragment target;
    private ExtElements xelems;
    private ExtAttributes xattrs;
    private String annotatorRef;
    private Metadata metadata;

    public static Match annotate(Fragment fragment, int start, int end, Match match) {
        MTag am = fragment.getOrCreateMarker(start, end, ELEM_MTC_MATCH, ELEM_MTC_MATCH);
        match.setRef(MATCH_REF_PREFIX + am.getId());
        Unit unit = (Unit)fragment.getStore().getParent();
        unit.getMatches().add(match);
        return match;
    }

    public Match() {
    }

    public Match(Match original) {
        this.id = original.id;
        this.type = original.type;
        this.subType = original.subType;
        this.similarity = original.similarity;
        this.matchQuality = original.matchQuality;
        this.matchSuitability = original.matchSuitability;
        this.ref = original.ref;
        this.origin = original.origin;
        this.reference = original.reference;
        this.annotatorRef = original.annotatorRef;
        if (original.source != null) {
            this.source = new Fragment(original.source, this.store, false);
        }
        if (original.target != null) {
            this.target = new Fragment(original.target, this.store, true);
        }
        if (original.hasExtElements()) {
            this.xelems = new ExtElements(original.xelems);
        }
        if (original.hasMetadata()) {
            this.metadata = new Metadata(original.metadata);
        }
        if (original.hasExtAttribute()) {
            this.xattrs = new ExtAttributes(original.xattrs);
        }
    }

    public Store getStore() {
        return this.store;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type == null) {
            this.type = DEFAULT_TYPE;
        } else {
            Util.checkValueList("am;mt;icm;idm;tb;tm;other", type, "match type");
            this.type = type;
        }
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        int n;
        if (subType != null && ((n = subType.indexOf(58)) == -1 || n == 0 || n == subType.length() - 1)) {
            throw new InvalidParameterException(String.format("Invalid value '%s' for match subType.", subType));
        }
        this.subType = subType;
    }

    public Double getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(Double similarity) {
        if (similarity != null && (similarity < 0.0 || similarity > 100.0)) {
            throw new InvalidParameterException(String.format("The value '%f' is out of the [0.0 to 100.0] range.", similarity));
        }
        this.similarity = similarity;
    }

    public Double getMatchQuality() {
        return this.matchQuality;
    }

    public void setMatchQuality(Double matchQuality) {
        if (matchQuality != null && (matchQuality < 0.0 || matchQuality > 100.0)) {
            throw new InvalidParameterException(String.format("The value '%f' is out of the [0.0 to 100.0] range.", matchQuality));
        }
        this.matchQuality = matchQuality;
    }

    public Double getMatchSuitability() {
        return this.matchSuitability;
    }

    public void setMatchSuitability(Double matchSuitability) {
        if (matchSuitability != null && (matchSuitability < 0.0 || matchSuitability > 100.0)) {
            throw new InvalidParameterException(String.format("The value '%f' is out of the [0.0 to 100.0] range.", matchSuitability));
        }
        this.matchSuitability = matchSuitability;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean isReference() {
        return this.reference;
    }

    public void setReference(boolean reference) {
        this.reference = reference;
    }

    public Fragment getSource() {
        return this.source;
    }

    public void setSource(Fragment source) {
        this.source = source;
    }

    public Fragment getTarget() {
        return this.target;
    }

    public void setTarget(Fragment target) {
        this.target = target;
    }

    @Override
    public ExtElements getExtElements() {
        if (this.xelems == null) {
            this.xelems = new ExtElements();
        }
        return this.xelems;
    }

    @Override
    public boolean hasExtElements() {
        if (this.xelems == null) {
            return false;
        }
        return this.xelems.size() > 0;
    }

    @Override
    public ExtElements setExtElements(ExtElements elements) {
        this.xelems = elements;
        return this.getExtElements();
    }

    @Override
    public boolean isIdUsed(String id) {
        return this.store.isIdUsedInTags(id);
    }

    @Override
    public Directionality getSourceDir() {
        return null;
    }

    @Override
    public void setSourceDir(Directionality dir) {
    }

    @Override
    public Directionality getTargetDir() {
        return null;
    }

    @Override
    public void setTargetDir(Directionality dir) {
    }

    @Override
    public void setExtAttributes(ExtAttributes attributes) {
        this.xattrs = attributes;
    }

    @Override
    public ExtAttributes getExtAttributes() {
        if (this.xattrs == null) {
            this.xattrs = new ExtAttributes();
        }
        return this.xattrs;
    }

    @Override
    public boolean hasExtAttribute() {
        if (this.xattrs == null) {
            return false;
        }
        return !this.xattrs.isEmpty();
    }

    @Override
    public String getExtAttributeValue(String namespaceURI, String localName) {
        if (this.xattrs == null) {
            return null;
        }
        return this.xattrs.getAttributeValue(namespaceURI, localName);
    }

    public String getAnnotatorRef() {
        return this.annotatorRef;
    }

    public void setAnnoatorRef(String annotatorRef) {
        this.annotatorRef = annotatorRef;
    }

    public Double getMTConfidence() {
        if (this.matchQuality != null) {
            return this.matchQuality / 100.0;
        }
        return null;
    }

    public void setMTConfidence(Double mtConfidence) {
        if (mtConfidence == null) {
            this.matchQuality = null;
            return;
        }
        if (mtConfidence < 0.0 || mtConfidence > 1.0) {
            throw new InvalidParameterException(String.format("The value '%f' is out of the [0.0 to 1.0] range.", mtConfidence));
        }
        this.matchQuality = mtConfidence * 100.0;
    }

    @Override
    public boolean hasMetadata() {
        if (this.metadata == null) {
            return false;
        }
        return !this.metadata.isEmpty();
    }

    @Override
    public Metadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }
}

