/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.walker;

import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.FileNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.walker.AbstractXliffWalkerStrategy;
import net.sf.okapi.lib.xliff2.walker.IXliffVisitor;
import net.sf.okapi.lib.xliff2.walker.VisitationContext;
import net.sf.okapi.lib.xliff2.walker.XliffWalker;

public class DefaultXliffWalkerStrategy
extends AbstractXliffWalkerStrategy {
    public DefaultXliffWalkerStrategy(XliffWalker walker) {
        super(walker);
    }

    @Override
    public void doWalk() {
        for (String fileNodeID : this.walker.getFileNodeIds()) {
            FileNode fileNode = this.walker.getFileNode(fileNodeID);
            for (IXliffVisitor<FileNode> visitor : this.walker.getFileNodeVisitors()) {
                visitor.visit(fileNode, new VisitationContext(fileNode));
            }
            for (UnitNode unitNode : fileNode.getUnitNodes()) {
                Unit unit = unitNode.get();
                for (IXliffVisitor<UnitNode> visitor : this.walker.getUnitNodeVisitors()) {
                    visitor.visit(unitNode, new VisitationContext(fileNode, unitNode));
                }
                int segmentIndex = 0;
                for (Segment segment : unit.getSegments()) {
                    for (IXliffVisitor<Segment> visitor : this.walker.getSegmentVisitors()) {
                        visitor.visit(segment, new VisitationContext(fileNode, unitNode, segmentIndex));
                    }
                    ++segmentIndex;
                }
            }
        }
    }
}

