/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.ui.mapping;

import net.sf.okapi.common.ui.abstracteditor.IDialogPage;
import net.sf.okapi.common.ui.abstracteditor.SWTUtil;
import net.sf.okapi.common.ui.abstracteditor.TableAdapter;
import net.sf.okapi.steps.tokenization.ui.mapping.MappingItemPage;
import net.sf.okapi.steps.tokenization.ui.mapping.model.MappingItem;
import net.sf.okapi.steps.tokenization.ui.mapping.model.Parameters;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class MappingTab
extends Composite
implements IDialogPage {
    private Table table;
    private TableColumn tblclmnParameters;
    private TableColumn tblclmnEditor;
    private Button btnAdd;
    private Button btnModify;
    private Button btnRemove;
    private Label label;
    private TableAdapter adapter;
    private Label lblThisFormMaps;
    private boolean modified;

    public MappingTab(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new GridLayout(2, false));
        this.lblThisFormMaps = new Label(this, 0);
        this.lblThisFormMaps.setData("name", "lblThisFormMaps");
        this.lblThisFormMaps.setText("This table maps parameters editor classes to their parameters classes.");
        new Label(this, 0);
        this.table = new Table(this, 67584);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                MappingTab.this.addModifyRow(MappingTab.this.table.getItem(new Point(e.x, e.y)));
            }
        });
        GridData gridData = new GridData(4, 4, true, true, 1, 4);
        gridData.heightHint = 400;
        gridData.widthHint = 600;
        this.table.setLayoutData(gridData);
        this.table.setData("name", "table");
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tblclmnEditor = new TableColumn(this.table, 0);
        this.tblclmnEditor.setData("name", "tblclmnEditor");
        this.tblclmnEditor.setWidth(100);
        this.tblclmnEditor.setText("Editor class");
        this.btnAdd = new Button(this, 0);
        this.btnAdd.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MappingTab.this.addModifyRow(null);
            }
        });
        this.btnAdd.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAdd.setData("name", "btnAdd");
        this.btnAdd.setText("Add...");
        this.btnModify = new Button(this, 0);
        this.btnModify.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MappingTab.this.addModifyRow(MappingTab.this.table.getItem(MappingTab.this.table.getSelectionIndex()));
            }
        });
        this.btnModify.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnModify.setData("name", "btnModify");
        this.btnModify.setText("Modify...");
        this.btnRemove = new Button(this, 0);
        this.btnRemove.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MappingTab.this.adapter.removeSelected();
                MappingTab.this.modified = true;
                MappingTab.this.interop(e.widget);
            }
        });
        this.btnRemove.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnRemove.setData("name", "btnRemove");
        this.btnRemove.setText("Remove");
        this.label = new Label(this, 0);
        this.label.setText("                         ");
        this.label.setData("name", "label");
        this.tblclmnParameters = new TableColumn(this.table, 0);
        this.tblclmnParameters.setData("name", "tblclmnParameters");
        this.tblclmnParameters.setWidth(100);
        this.tblclmnParameters.setText("Parameters class");
        this.adapter = new TableAdapter(this.table);
        this.adapter.setRelColumnWidths(new double[]{1.0, 1.0});
    }

    @Override
    public boolean canClose(boolean isOK) {
        return true;
    }

    @Override
    public void interop(Widget speaker) {
        this.btnModify.setEnabled(this.table.getItemCount() > 0 && this.table.getSelectionIndex() != -1);
        this.btnRemove.setEnabled(this.btnModify.getEnabled());
    }

    protected void addModifyRow(TableItem item) {
        if (item == null) {
            this.adapter.unselect();
            Object res = SWTUtil.inputQuery(MappingItemPage.class, this.getShell(), "Add mapping", new String[]{"", ""}, null);
            if (res != null) {
                this.modified = true;
                this.adapter.addModifyRow((String[])res, 1, 3);
            } else {
                this.adapter.restoreSelection();
            }
        } else {
            Object res = SWTUtil.inputQuery(MappingItemPage.class, this.getShell(), "Modify mapping", SWTUtil.getText(item), null);
            if (res != null) {
                this.modified = true;
                this.adapter.modifyRow(item, (String[])res);
            }
        }
        this.adapter.sort(1, false);
        this.interop(this.table);
    }

    @Override
    public boolean load(Object data) {
        if (data instanceof Parameters) {
            Parameters params = (Parameters)((Object)data);
            if (!params.loadFromResource("mapper.tprm")) {
                return false;
            }
            this.adapter.clear();
            for (MappingItem item : params.getItems()) {
                this.adapter.addRow(new String[]{item.editorClass, item.parametersClass});
            }
            this.adapter.sort(1, false);
            this.modified = false;
        }
        return true;
    }

    @Override
    public boolean save(Object data) {
        if (data instanceof Parameters) {
            Parameters params = (Parameters)((Object)data);
            params.reset();
            for (int i = 1; i <= this.adapter.getNumRows(); ++i) {
                params.addMapping(this.adapter.getValue(i, 1), this.adapter.getValue(i, 2));
            }
            if (this.modified) {
                params.saveToResource("mapper.tprm");
            }
            this.modified = false;
        }
        return true;
    }
}

