/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    static HTMLTransfer _instance = new HTMLTransfer();
    static final String HTML_FORMAT = "HTML Format";
    static final int HTML_FORMATID = HTMLTransfer.registerType("HTML Format");
    static final String NUMBER = "00000000";
    static final String HEADER = "Version:0.9\r\nStartHTML:00000000\r\nEndHTML:00000000\r\nStartFragment:00000000\r\nEndFragment:00000000\r\n";
    static final String PREFIX = "<html><body><!--StartFragment-->";
    static final String SUFFIX = "<!--EndFragment--></body></html>";
    static final String StartFragment = "StartFragment:";
    static final String EndFragment = "EndFragment:";

    private HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int n = string.length();
        char[] cArray = new char[n + 1];
        string.getChars(0, n, cArray, 0);
        int n2 = OS.WideCharToMultiByte(65001, 0, cArray, -1, null, 0, null, null);
        if (n2 == 0) {
            transferData.stgmedium = new STGMEDIUM();
            transferData.result = -2147221402;
            return;
        }
        int n3 = HEADER.length();
        int n4 = n3 + PREFIX.length();
        int n5 = n4 + n2 - 1;
        int n6 = n5 + SUFFIX.length();
        StringBuffer stringBuffer = new StringBuffer(HEADER);
        int n7 = NUMBER.length();
        int n8 = stringBuffer.toString().indexOf(NUMBER);
        String string2 = Integer.toString(n3);
        stringBuffer.replace(n8 + n7 - string2.length(), n8 + n7, string2);
        n8 = stringBuffer.toString().indexOf(NUMBER, n8);
        string2 = Integer.toString(n6);
        stringBuffer.replace(n8 + n7 - string2.length(), n8 + n7, string2);
        n8 = stringBuffer.toString().indexOf(NUMBER, n8);
        string2 = Integer.toString(n4);
        stringBuffer.replace(n8 + n7 - string2.length(), n8 + n7, string2);
        n8 = stringBuffer.toString().indexOf(NUMBER, n8);
        string2 = Integer.toString(n5);
        stringBuffer.replace(n8 + n7 - string2.length(), n8 + n7, string2);
        stringBuffer.append(PREFIX);
        stringBuffer.append(string);
        stringBuffer.append(SUFFIX);
        n = stringBuffer.length();
        cArray = new char[n + 1];
        stringBuffer.getChars(0, n, cArray, 0);
        n2 = OS.WideCharToMultiByte(65001, 0, cArray, -1, null, 0, null, null);
        long l = OS.GlobalAlloc(64, n2);
        OS.WideCharToMultiByte(65001, 0, cArray, -1, l, n2, null, null);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = l;
        transferData.stgmedium.pUnkForRelease = 0L;
        transferData.result = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0L) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        FORMATETC fORMATETC = transferData.formatetc;
        sTGMEDIUM.tymed = 1;
        transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        long l = sTGMEDIUM.unionField;
        try {
            String string;
            char[] cArray;
            int n;
            block25: {
                int n2;
                int n3;
                long l2;
                block24: {
                    block23: {
                        l2 = OS.GlobalLock(l);
                        if (l2 == 0L) {
                            Object var9_7 = null;
                            return var9_7;
                        }
                        n = OS.MultiByteToWideChar(65001, 0, l2, -1, null, 0);
                        if (n != 0) break block23;
                        Object var10_9 = null;
                        OS.GlobalUnlock(l);
                        return var10_9;
                    }
                    try {
                        int n4;
                        cArray = new char[n - 1];
                        OS.MultiByteToWideChar(65001, 0, l2, -1, cArray, cArray.length);
                        String string2 = new String(cArray);
                        n3 = 0;
                        n2 = 0;
                        int n5 = string2.indexOf(StartFragment) + StartFragment.length();
                        for (n4 = n5 + 1; n4 < string2.length(); ++n4) {
                            string = string2.substring(n5, n4);
                            try {
                                n3 = Integer.parseInt(string);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                break;
                            }
                        }
                        n5 = string2.indexOf(EndFragment) + EndFragment.length();
                        for (n4 = n5 + 1; n4 < string2.length(); ++n4) {
                            string = string2.substring(n5, n4);
                            try {
                                n2 = Integer.parseInt(string);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                break;
                            }
                        }
                        if (n2 > n3 && n2 <= OS.strlen(l2)) break block24;
                        string = null;
                    }
                    catch (Throwable throwable) {
                        OS.GlobalUnlock(l);
                        throw throwable;
                    }
                    OS.GlobalUnlock(l);
                    return string;
                }
                n = OS.MultiByteToWideChar(65001, 0, l2 + (long)n3, n2 - n3, cArray, cArray.length);
                if (n != 0) break block25;
                string = null;
                OS.GlobalUnlock(l);
                return string;
            }
            string = new String(cArray, 0, n);
            String string3 = "<!--StartFragment -->\r\n";
            int n6 = string.indexOf(string3);
            if (n6 != -1) {
                string = string.substring(n6 += string3.length());
            }
            String string4 = string;
            OS.GlobalUnlock(l);
            return string4;
        }
        finally {
            OS.GlobalFree(l);
        }
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{HTML_FORMATID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{HTML_FORMAT};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

