/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.win32.OS;

public final class Color
extends Resource {
    public int handle;
    int alpha = 255;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int n, int n2, int n3) {
        super(device);
        this.init(n, n2, n3, 255);
        this.init();
    }

    public Color(Device device, int n, int n2, int n3, int n4) {
        super(device);
        this.init(n, n2, n3, n4);
        this.init();
    }

    public Color(Device device, RGB rGB) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, 255);
        this.init();
    }

    public Color(Device device, RGBA rGBA) {
        super(device);
        if (rGBA == null) {
            SWT.error(4);
        }
        this.init(rGBA.rgb.red, rGBA.rgb.green, rGBA.rgb.blue, rGBA.alpha);
        this.init();
    }

    public Color(Device device, RGB rGB, int n) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, n);
        this.init();
    }

    @Override
    void destroy() {
        int n;
        int[] nArray;
        long l = this.device.hPalette;
        if (l != 0L && (nArray = this.device.colorRefCount)[n = OS.GetNearestPaletteIndex(l, this.handle)] > 0) {
            int n2 = n;
            nArray[n2] = nArray[n2] - 1;
        }
        this.handle = -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        return this.device == color.device && (this.handle & 0xFFFFFF) == (color.handle & 0xFFFFFF) && this.alpha == color.alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF0000) >> 16;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF00) >> 8;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle & 0xFF;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.handle & 0xFF, (this.handle & 0xFF00) >> 8, (this.handle & 0xFF0000) >> 16);
    }

    public RGBA getRGBA() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGBA(this.handle & 0xFF, (this.handle & 0xFF00) >> 8, (this.handle & 0xFF0000) >> 16, this.alpha);
    }

    public int hashCode() {
        return this.handle ^ this.alpha;
    }

    void init(int n, int n2, int n3, int n4) {
        int n5;
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0 || n4 > 255 || n4 < 0) {
            SWT.error(5);
        }
        this.handle = n & 0xFF | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 16;
        this.alpha = n4;
        long l = this.device.hPalette;
        if (l == 0L) {
            return;
        }
        int[] nArray = this.device.colorRefCount;
        int n6 = OS.GetNearestPaletteIndex(l, this.handle);
        byte[] byArray = new byte[4];
        OS.GetPaletteEntries(l, n6, 1, byArray);
        if (byArray[0] == (byte)n && byArray[1] == (byte)n2 && byArray[2] == (byte)n3) {
            int n7 = n6;
            nArray[n7] = nArray[n7] + 1;
            return;
        }
        for (n5 = 0; n5 < nArray.length; ++n5) {
            if (nArray[n5] != 0) continue;
            n6 = n5;
            break;
        }
        if (n5 == nArray.length) {
            this.handle = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16;
        } else {
            byArray = new byte[]{(byte)(n & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 & 0xFF), 0};
            OS.SetPaletteEntries(l, n6, 1, byArray);
        }
        int n8 = n6;
        nArray[n8] = nArray[n8] + 1;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == -1;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "}";
    }

    public static Color win32_new(Device device, int n) {
        return Color.win32_new(device, n, 255);
    }

    public static Color win32_new(Device device, int n, int n2) {
        Color color = new Color(device);
        color.handle = n;
        color.alpha = n2;
        return color;
    }
}

