/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.DISPPARAMS;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IConnectionPoint;
import org.eclipse.swt.internal.ole.win32.IConnectionPointContainer;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleEventTable;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

final class OleEventSink {
    private OleControlSite widget;
    private COMObject iDispatch;
    private int refCount;
    private IUnknown objIUnknown;
    private int eventCookie;
    private GUID eventGuid;
    private OleEventTable eventTable;

    OleEventSink(OleControlSite oleControlSite, long l, GUID gUID) {
        this.widget = oleControlSite;
        this.eventGuid = gUID;
        this.objIUnknown = new IUnknown(l);
        this.createCOMInterfaces();
    }

    void connect() {
        long[] lArray = new long[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIConnectionPointContainer, lArray) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(lArray[0]);
            long[] lArray2 = new long[1];
            if (iConnectionPointContainer.FindConnectionPoint(this.eventGuid, lArray2) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(lArray2[0]);
                int[] nArray = new int[1];
                if (iConnectionPoint.Advise(this.iDispatch.getAddress(), nArray) == 0) {
                    this.eventCookie = nArray[0];
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    void addListener(int n, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new OleEventTable();
        }
        this.eventTable.hook(n, oleListener);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private void createCOMInterfaces() {
        this.iDispatch = new COMObject(new int[]{2, 0, 0, 1, 3, 4, 8}){

            @Override
            public long method0(long[] lArray) {
                return OleEventSink.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return OleEventSink.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return OleEventSink.this.Release();
            }

            @Override
            public long method6(long[] lArray) {
                return OleEventSink.this.Invoke((int)lArray[0], lArray[1], (int)lArray[2], (int)lArray[3], lArray[4], lArray[5], lArray[6], lArray[7]);
            }
        };
    }

    void disconnect() {
        long[] lArray;
        if (this.eventCookie != 0 && this.objIUnknown != null && this.objIUnknown.QueryInterface(COM.IIDIConnectionPointContainer, lArray = new long[1]) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(lArray[0]);
            if (iConnectionPointContainer.FindConnectionPoint(this.eventGuid, lArray) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(lArray[0]);
                if (iConnectionPoint.Unadvise(this.eventCookie) == 0) {
                    this.eventCookie = 0;
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    private void disposeCOMInterfaces() {
        if (this.iDispatch != null) {
            this.iDispatch.dispose();
        }
        this.iDispatch = null;
    }

    private int Invoke(int n, long l, int n2, int n3, long l2, long l3, long l4, long l5) {
        int n4;
        Object object;
        if (this.eventTable == null || !this.eventTable.hooks(n)) {
            return 0;
        }
        Variant[] variantArray = null;
        if (l2 != 0L) {
            object = new DISPPARAMS();
            COM.MoveMemory((DISPPARAMS)object, l2, DISPPARAMS.sizeof);
            variantArray = new Variant[((DISPPARAMS)object).cArgs];
            n4 = VARIANT.sizeof;
            long l6 = (((DISPPARAMS)object).cArgs - 1) * n4;
            for (int i = 0; i < ((DISPPARAMS)object).cArgs; ++i) {
                variantArray[i] = new Variant();
                variantArray[i].setData(((DISPPARAMS)object).rgvarg + l6);
                l6 -= (long)n4;
            }
        }
        object = new OleEvent();
        ((OleEvent)object).arguments = variantArray;
        this.notifyListener(n, (OleEvent)object);
        if (variantArray != null) {
            for (n4 = 0; n4 < variantArray.length; ++n4) {
                variantArray[n4].dispose();
            }
        }
        return 0;
    }

    private void notifyListener(int n, OleEvent oleEvent) {
        if (oleEvent == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        oleEvent.type = n;
        oleEvent.widget = this.widget;
        this.eventTable.sendEvent(oleEvent);
    }

    private int QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDispatch) || COM.IsEqualGUID(gUID, this.eventGuid)) {
            COM.MoveMemory(l2, new long[]{this.iDispatch.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(l2, new long[]{0L}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    void removeListener(int n, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, oleListener);
    }

    boolean hasListeners() {
        return this.eventTable.hasEntries();
    }
}

