/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.COMPOSITIONFORM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;

    Canvas() {
    }

    public Canvas(Composite composite, int n) {
        super(composite, n);
    }

    void clearArea(int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (OS.IsWindowVisible(this.handle)) {
            RECT rECT = new RECT();
            OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
            long l = OS.GetDCEx(this.handle, 0L, 26);
            this.drawBackground(l, rECT);
            OS.ReleaseDC(this.handle, l);
        }
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        this.drawBackgroundInPixels(gC, n, n2, n3, n4, 0, 0);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void reskinChildren(int n) {
        if (this.caret != null) {
            this.caret.reskin(n);
        }
        if (this.ime != null) {
            this.ime.reskin(n);
        }
        super.reskinChildren(n);
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.checkWidget();
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        n5 = DPIUtil.autoScaleUp(n5);
        n6 = DPIUtil.autoScaleUp(n6);
        this.scrollInPixels(n, n2, n3, n4, n5, n6, bl);
    }

    void scrollInPixels(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        int n8;
        boolean bl2;
        this.forceResize();
        boolean bl3 = bl2 = this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n3, n4, n3 + n5, n4 + n6);
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        if (OS.IntersectRect(rECT2, rECT, rECT2)) {
            if (OS.IsWinCE) {
                OS.UpdateWindow(this.handle);
            } else {
                n8 = 384;
                OS.RedrawWindow(this.handle, null, 0L, n8);
            }
        }
        n8 = n - n3;
        int n9 = n2 - n4;
        if (this.findImageControl() != null) {
            if (OS.IsWinCE) {
                OS.InvalidateRect(this.handle, rECT, true);
            } else {
                n7 = 1029;
                if (bl) {
                    n7 |= 0x80;
                }
                OS.RedrawWindow(this.handle, rECT, 0L, n7);
            }
            OS.OffsetRect(rECT, n8, n9);
            if (OS.IsWinCE) {
                OS.InvalidateRect(this.handle, rECT, true);
            } else {
                n7 = 1029;
                if (bl) {
                    n7 |= 0x80;
                }
                OS.RedrawWindow(this.handle, rECT, 0L, n7);
            }
        } else {
            n7 = 6;
            OS.ScrollWindowEx(this.handle, n8, n9, rECT, null, 0L, null, n7);
        }
        if (bl) {
            Control[] controlArray = this._getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                Control control = controlArray[i];
                Rectangle rectangle = control.getBoundsInPixels();
                if (Math.min(n3 + n5, rectangle.x + rectangle.width) < Math.max(n3, rectangle.x) || Math.min(n4 + n6, rectangle.y + rectangle.height) < Math.max(n4, rectangle.y)) continue;
                control.setLocationInPixels(rectangle.x + n8, rectangle.y + n9);
            }
        }
        if (bl2) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME iME) {
        this.checkWidget();
        if (iME != null && iME.isDisposed()) {
            this.error(5);
        }
        this.ime = iME;
    }

    @Override
    TCHAR windowClass() {
        if (this.display.useOwnDC) {
            return this.display.windowOwnDCClass;
        }
        return super.windowClass();
    }

    @Override
    long windowProc(long l, int n, long l2, long l3) {
        if (n == Display.SWT_RESTORECARET && (this.state & 2) != 0 && this.caret != null) {
            this.caret.killFocus();
            this.caret.setFocus();
            return 1L;
        }
        return super.windowProc(l, n, l2, l3);
    }

    @Override
    LRESULT WM_CHAR(long l, long l2) {
        LRESULT lRESULT = super.WM_CHAR(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.caret != null) {
            switch ((int)l) {
                case 8: 
                case 27: 
                case 127: {
                    break;
                }
                default: {
                    int[] nArray;
                    if (OS.GetKeyState(17) < 0 || !OS.SystemParametersInfo(4128, 0, nArray = new int[1], 0) || nArray[0] == 0) break;
                    OS.SetCursor(0L);
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_IME_COMPOSITION(long l, long l2) {
        POINT pOINT;
        short s;
        short s2;
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_IME_COMPOSITION(l, l2)) != null) {
            return lRESULT;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION == OS.VERSION(5, 1) && OS.IsDBLocale && (s2 = OS.PRIMARYLANGID(s = OS.GetSystemDefaultUILanguage())) == 18 && this.caret != null && this.caret.isFocusCaret() && OS.GetCaretPos(pOINT = new POINT())) {
            COMPOSITIONFORM cOMPOSITIONFORM = new COMPOSITIONFORM();
            cOMPOSITIONFORM.dwStyle = 2;
            cOMPOSITIONFORM.x = pOINT.x;
            cOMPOSITIONFORM.y = pOINT.y;
            long l3 = OS.ImmGetContext(this.handle);
            OS.ImmSetCompositionWindow(l3, cOMPOSITIONFORM);
            OS.ImmReleaseContext(this.handle, l3);
        }
        return super.WM_IME_COMPOSITION(l, l2);
    }

    @Override
    LRESULT WM_IME_COMPOSITION_START(long l, long l2) {
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_IME_COMPOSITION_START(l, l2)) != null) {
            return lRESULT;
        }
        return super.WM_IME_COMPOSITION_START(l, l2);
    }

    @Override
    LRESULT WM_IME_ENDCOMPOSITION(long l, long l2) {
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_IME_ENDCOMPOSITION(l, l2)) != null) {
            return lRESULT;
        }
        return super.WM_IME_ENDCOMPOSITION(l, l2);
    }

    @Override
    LRESULT WM_INPUTLANGCHANGE(long l, long l2) {
        LRESULT lRESULT = super.WM_INPUTLANGCHANGE(l, l2);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.setIMEFont();
            this.caret.resizeIME();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_KEYDOWN(long l, long l2) {
        LRESULT lRESULT = super.WM_KEYDOWN(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.ime != null) {
            this.ime.WM_KEYDOWN(l, l2);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_KILLFOCUS(long l, long l2) {
        Object object;
        if (this.ime != null && (object = this.ime.WM_KILLFOCUS(l, l2)) != null) {
            return object;
        }
        object = this.caret;
        LRESULT lRESULT = super.WM_KILLFOCUS(l, l2);
        if (object != null) {
            ((Caret)object).killFocus();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_LBUTTONDOWN(l, l2)) != null) {
            return lRESULT;
        }
        return super.WM_LBUTTONDOWN(l, l2);
    }

    @Override
    LRESULT WM_SETFOCUS(long l, long l2) {
        LRESULT lRESULT = super.WM_SETFOCUS(l, l2);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.setFocus();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SIZE(long l, long l2) {
        LRESULT lRESULT = super.WM_SIZE(l, l2);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.resizeIME();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGED(long l, long l2) {
        boolean bl;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGED(l, l2);
        boolean bl2 = bl = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.setFocus();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(long l, long l2) {
        boolean bl;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl2 = bl = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        return lRESULT;
    }
}

