/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.LITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMLINK;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color disabledColor;
    int linkForeground = -1;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    int mouseDownIndex;
    long font;
    static final RGB LAST_FALLBACK_LINK_FOREGROUND = new RGB(0, 51, 153);
    static final long LinkProc;
    static final TCHAR LinkClass;

    public Link(Composite composite, int n) {
        super(composite, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        if (LinkProc != 0L) {
            switch (n) {
                case 15: {
                    if (l2 == 0L) break;
                    OS.SendMessage(l, 792, l2, 0L);
                    return 0L;
                }
            }
            return OS.CallWindowProc(LinkProc, l, n, l2, l3);
        }
        return OS.DefWindowProc(l, n, l2, l3);
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        int n3;
        int n4;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if (this.useCommonControl()) {
            long l = OS.GetDC(this.handle);
            long l2 = OS.SendMessage(this.handle, 49, 0L, 0L);
            long l3 = OS.SelectObject(l, l2);
            if (this.text.length() > 0) {
                TCHAR tCHAR = new TCHAR(this.getCodePage(), this.parse(this.text), false);
                RECT rECT = new RECT();
                int n5 = 3072;
                if (n != -1) {
                    n5 |= 0x10;
                    rECT.right = n;
                }
                OS.DrawText(l, tCHAR, tCHAR.length(), rECT, n5);
                n4 = rECT.right - rECT.left;
                n3 = rECT.bottom;
            } else {
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(l, tEXTMETRIC);
                n4 = 0;
                n3 = tEXTMETRIC.tmHeight;
            }
            if (l2 != 0L) {
                OS.SelectObject(l, l3);
            }
            OS.ReleaseDC(this.handle, l);
        } else {
            int n6 = this.layout.getWidth();
            if (n == 0) {
                this.layout.setWidth(1);
                Rectangle rectangle = DPIUtil.autoScaleUp(this.layout.getBounds());
                n4 = 0;
                n3 = rectangle.height;
            } else {
                this.layout.setWidth(DPIUtil.autoScaleDown(n));
                Rectangle rectangle = DPIUtil.autoScaleUp(this.layout.getBounds());
                n4 = rectangle.width;
                n3 = rectangle.height;
            }
            this.layout.setWidth(n6);
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n3 = n2;
        }
        int n7 = this.getBorderWidthInPixels();
        return new Point(n4 += n7 * 2, n3 += n7 * 2);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
        this.layout = new TextLayout(this.display);
        this.disabledColor = Color.win32_new(this.display, OS.GetSysColor(OS.COLOR_GRAYTEXT));
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.selection = new Point(-1, -1);
        this.mouseDownIndex = -1;
        this.focusIndex = -1;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.text = "";
        if ((this.style & 0x8000000) != 0) {
            this.layout.setOrientation(0x4000000);
        }
        this.initAccessible();
    }

    void drawWidget(GC gC, RECT rECT) {
        Rectangle[] rectangleArray;
        this.drawBackground(gC.handle, rECT);
        int n = this.selection.x;
        int n2 = this.selection.y;
        if (n > n2) {
            n = this.selection.y;
            n2 = this.selection.x;
        }
        n2 = -1;
        n = -1;
        if (!OS.IsWindowEnabled(this.handle)) {
            gC.setForeground(this.disabledColor);
        }
        this.layout.draw(gC, 0, 0, n, n2, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            rectangleArray = this.getRectanglesInPixels(this.focusIndex);
            for (int i = 0; i < rectangleArray.length; ++i) {
                Rectangle rectangle = DPIUtil.autoScaleDown(rectangleArray[i]);
                gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (this.hooks(9) || this.filters(9)) {
            rectangleArray = new Event();
            rectangleArray.gc = gC;
            rectangleArray.setBoundsInPixels(new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top));
            this.sendEvent(9, (Event)rectangleArray);
            rectangleArray.gc = null;
        }
    }

    @Override
    void enableWidget(boolean bl) {
        if (this.useCommonControl(bl)) {
            LITEM lITEM = new LITEM();
            lITEM.mask = 3;
            lITEM.stateMask = 2;
            int n = lITEM.state = bl ? 2 : 0;
            while (OS.SendMessage(this.handle, 1794, 0L, lITEM) != 0L) {
                ++lITEM.iLink;
            }
        }
        this.styleLinkParts(bl);
        this.redraw();
        super.enableWidget(bl);
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Link.this.parse(Link.this.text);
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = -1;
            }

            @Override
            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = Link.this.display.mapInPixels((Control)Link.this.getParent(), null, Link.this.getBoundsInPixels());
                accessibleControlEvent.x = rectangle.x;
                accessibleControlEvent.y = rectangle.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            @Override
            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            @Override
            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 30;
            }

            @Override
            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0x100000;
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.detail |= 4;
                }
            }

            @Override
            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = SWT.getMessage("SWT_Press");
            }

            @Override
            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }

            @Override
            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }
        });
    }

    public Color getLinkForeground() {
        this.checkWidget();
        return this.internalGetLinkForeground();
    }

    Color internalGetLinkForeground() {
        if (this.linkForeground != -1) {
            return Color.win32_new(this.display, this.linkForeground);
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            return Color.win32_new(this.display, OS.GetSysColor(OS.COLOR_HOTLIGHT));
        }
        Color color = new Color((Device)this.display, LAST_FALLBACK_LINK_FOREGROUND);
        this.linkForeground = color.handle;
        return color;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectanglesInPixels(int n) {
        int n2 = this.layout.getLineCount();
        Rectangle[] rectangleArray = new Rectangle[n2];
        int[] nArray = this.layout.getLineOffsets();
        Point point = this.offsets[n];
        int n3 = 1;
        while (point.x > nArray[n3]) {
            ++n3;
        }
        int n4 = 1;
        while (point.y > nArray[n4]) {
            ++n4;
        }
        int n5 = 0;
        if (n3 == n4) {
            rectangleArray[n5++] = DPIUtil.autoScaleUp(this.layout.getBounds(point.x, point.y));
        } else {
            rectangleArray[n5++] = DPIUtil.autoScaleUp(this.layout.getBounds(point.x, nArray[n3] - 1));
            rectangleArray[n5++] = DPIUtil.autoScaleUp(this.layout.getBounds(nArray[n4 - 1], point.y));
            if (n4 - n3 > 1) {
                for (int i = n3; i < n4 - 1; ++i) {
                    rectangleArray[n5++] = DPIUtil.autoScaleUp(this.layout.getLineBounds(i));
                }
            }
        }
        if (rectangleArray.length != n5) {
            Rectangle[] rectangleArray2 = new Rectangle[n5];
            System.arraycopy(rectangleArray, 0, rectangleArray2, 0, n5);
            rectangleArray = rectangleArray2;
        }
        return rectangleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    boolean mnemonicHit(char c) {
        if (this.mnemonics != null) {
            char c2 = Character.toUpperCase(c);
            String string = this.parse(this.text);
            for (int i = 0; i < this.mnemonics.length - 1; ++i) {
                char c3;
                if (this.mnemonics[i] == -1 || c2 != Character.toUpperCase(c3 = string.charAt(this.mnemonics[i]))) continue;
                if (!this.setFocus()) {
                    return false;
                }
                if (this.useCommonControl()) {
                    int n = OS.GetWindowLong(this.handle, -16);
                    LITEM lITEM = new LITEM();
                    lITEM.mask = 3;
                    lITEM.stateMask = 1;
                    while (lITEM.iLink < this.mnemonics.length) {
                        if (lITEM.iLink != i) {
                            OS.SendMessage(this.handle, 1794, 0L, lITEM);
                        }
                        ++lITEM.iLink;
                    }
                    lITEM.iLink = i;
                    lITEM.state = 1;
                    OS.SendMessage(this.handle, 1794, 0L, lITEM);
                    OS.SetWindowLong(this.handle, -16, n);
                } else {
                    this.focusIndex = i;
                    this.redraw();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        if (this.mnemonics != null) {
            char c2 = Character.toUpperCase(c);
            String string = this.parse(this.text);
            for (int i = 0; i < this.mnemonics.length - 1; ++i) {
                char c3;
                if (this.mnemonics[i] == -1 || c2 != Character.toUpperCase(c3 = string.charAt(this.mnemonics[i]))) continue;
                return true;
            }
        }
        return false;
    }

    String parse(String string) {
        int n;
        int n2;
        int n3 = string.length();
        this.offsets = new Point[n3 / 4];
        this.ids = new String[n3 / 4];
        this.mnemonics = new int[n3 / 4 + 1];
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[n3];
        string.getChars(0, string.length(), cArray, 0);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        block22: for (int i = 0; i < n3; ++i) {
            n2 = Character.toLowerCase(cArray[i]);
            switch (n4) {
                case 0: {
                    if (n2 != 60) continue block22;
                    n7 = i;
                    ++n4;
                    continue block22;
                }
                case 1: {
                    if (n2 != 97) continue block22;
                    ++n4;
                    continue block22;
                }
                case 2: {
                    switch (n2) {
                        case 104: {
                            n4 = 7;
                            continue block22;
                        }
                        case 62: {
                            n8 = i + 1;
                            ++n4;
                            continue block22;
                        }
                    }
                    if (Character.isWhitespace((char)n2)) continue block22;
                    n4 = 13;
                    continue block22;
                }
                case 3: {
                    if (n2 != 60) continue block22;
                    n9 = i;
                    ++n4;
                    continue block22;
                }
                case 4: {
                    n4 = n2 == 47 ? n4 + 1 : 3;
                    continue block22;
                }
                case 5: {
                    n4 = n2 == 97 ? n4 + 1 : 3;
                    continue block22;
                }
                case 6: {
                    if (n2 == 62) {
                        this.mnemonics[n5] = this.parseMnemonics(cArray, n6, n7, stringBuffer);
                        n = stringBuffer.length();
                        this.parseMnemonics(cArray, n8, n9, stringBuffer);
                        this.offsets[n5] = new Point(n, stringBuffer.length() - 1);
                        if (this.ids[n5] == null) {
                            this.ids[n5] = new String(cArray, n8, n9 - n8);
                        }
                        ++n5;
                        n9 = n10 = i + 1;
                        n8 = n10;
                        n7 = n10;
                        n6 = n10;
                        n4 = 0;
                        continue block22;
                    }
                    n4 = 3;
                    continue block22;
                }
                case 7: {
                    n4 = n2 == 114 ? n4 + 1 : 0;
                    continue block22;
                }
                case 8: {
                    n4 = n2 == 101 ? n4 + 1 : 0;
                    continue block22;
                }
                case 9: {
                    n4 = n2 == 102 ? n4 + 1 : 0;
                    continue block22;
                }
                case 10: {
                    n4 = n2 == 61 ? n4 + 1 : 0;
                    continue block22;
                }
                case 11: {
                    if (n2 == 34) {
                        ++n4;
                        n10 = i + 1;
                        continue block22;
                    }
                    n4 = 0;
                    continue block22;
                }
                case 12: {
                    if (n2 != 34) continue block22;
                    this.ids[n5] = new String(cArray, n10, i - n10);
                    n4 = 2;
                    continue block22;
                }
                case 13: {
                    if (Character.isWhitespace((char)n2)) {
                        n4 = 0;
                        continue block22;
                    }
                    if (n2 != 61) continue block22;
                    ++n4;
                    continue block22;
                }
                case 14: {
                    n4 = n2 == 34 ? n4 + 1 : 0;
                    continue block22;
                }
                case 15: {
                    if (n2 != 34) continue block22;
                    n4 = 2;
                    continue block22;
                }
                default: {
                    n4 = 0;
                }
            }
        }
        if (n6 < n3) {
            n2 = this.parseMnemonics(cArray, n6, n7, stringBuffer);
            n = this.parseMnemonics(cArray, Math.max(n7, n8), n3, stringBuffer);
            if (n == -1) {
                n = n2;
            }
            this.mnemonics[n5] = n;
        } else {
            this.mnemonics[n5] = -1;
        }
        if (this.offsets.length != n5) {
            Point[] pointArray = new Point[n5];
            System.arraycopy(this.offsets, 0, pointArray, 0, n5);
            this.offsets = pointArray;
            String[] stringArray = new String[n5];
            System.arraycopy(this.ids, 0, stringArray, 0, n5);
            this.ids = stringArray;
            int[] nArray = new int[n5 + 1];
            System.arraycopy(this.mnemonics, 0, nArray, 0, n5 + 1);
            this.mnemonics = nArray;
        }
        return stringBuffer.toString();
    }

    int parseMnemonics(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] == '&') {
                if (i + 1 < n2 && cArray[i + 1] == '&') {
                    stringBuffer.append(cArray[i]);
                    ++i;
                    continue;
                }
                n3 = stringBuffer.length();
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return n3;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setLinkForeground(Color color) {
        this.checkWidget();
        int n = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            n = color.handle;
        }
        if (n == this.linkForeground) {
            return;
        }
        this.linkForeground = n;
        if (OS.IsWindowEnabled(this.handle)) {
            this.styleLinkParts(true);
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        if ((this.state & 0x400000) != 0) {
            this.updateTextDirection(0x6000000);
        }
        boolean bl = OS.IsWindowEnabled(this.handle);
        String string2 = this.parse(this.text);
        if (Link.isCommonControlAvailable()) {
            if (string.length() == 0) {
                string = " ";
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.handle, tCHAR);
        }
        this.layout.setText(string2);
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        this.selection.y = -1;
        this.selection.x = -1;
        int n = OS.GetWindowLong(this.handle, -16);
        n = this.offsets.length > 0 ? (n |= 0x10000) : (n &= 0xFFFEFFFF);
        OS.SetWindowLong(this.handle, -16, n);
        this.styleLinkParts(bl);
        TextStyle textStyle = new TextStyle(null, null, null);
        textStyle.underline = true;
        for (int i = 0; i < this.mnemonics.length; ++i) {
            int n2 = this.mnemonics[i];
            if (n2 == -1) continue;
            this.layout.setStyle(textStyle, n2, n2);
        }
        if (this.useCommonControl()) {
            this.enableWidget(bl);
        } else {
            this.redraw();
        }
    }

    @Override
    int resolveTextDirection() {
        return BidiUtil.resolveTextDirection(this.text);
    }

    void styleLinkParts(boolean bl) {
        TextStyle textStyle = new TextStyle(null, bl ? this.internalGetLinkForeground() : this.disabledColor, null);
        textStyle.underline = true;
        for (int i = 0; i < this.offsets.length; ++i) {
            Point point = this.offsets[i];
            this.layout.setStyle(textStyle, point.x, point.y);
        }
    }

    @Override
    boolean updateTextDirection(int n) {
        if (super.updateTextDirection(n)) {
            int n2 = 0x6000000;
            this.style &= 0xF7FFFFFF;
            this.style &= ~n2;
            this.style |= n & n2;
            this.updateOrientation();
            this.checkMirrored();
            return true;
        }
        return false;
    }

    boolean useCommonControl() {
        return this.useCommonControl(OS.IsWindowEnabled(this.handle));
    }

    boolean useCommonControl(boolean bl) {
        return this.linkForeground == -1 && !bl && Link.isCommonControlAvailable();
    }

    static boolean isCommonControlAvailable() {
        return OS.COMCTL32_MAJOR >= 6;
    }

    @Override
    int widgetStyle() {
        int n = super.widgetStyle();
        return n | 0x10000;
    }

    @Override
    TCHAR windowClass() {
        return Link.isCommonControlAvailable() ? LinkClass : this.display.windowClass;
    }

    @Override
    long windowProc() {
        return LinkProc != 0L ? LinkProc : this.display.windowProc;
    }

    @Override
    LRESULT WM_CHAR(long l, long l2) {
        LRESULT lRESULT = super.WM_CHAR(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!this.useCommonControl()) {
            if (this.focusIndex == -1) {
                return lRESULT;
            }
            switch ((int)l) {
                case 13: 
                case 32: {
                    Event event = new Event();
                    event.text = this.ids[this.focusIndex];
                    this.sendSelectionEvent(13, event, true);
                    break;
                }
                case 9: {
                    boolean bl;
                    boolean bl2 = bl = OS.GetKeyState(16) >= 0;
                    if (bl) {
                        if (this.focusIndex >= this.offsets.length - 1) break;
                        ++this.focusIndex;
                        this.redraw();
                        break;
                    }
                    if (this.focusIndex <= 0) break;
                    --this.focusIndex;
                    this.redraw();
                }
            }
        } else {
            switch ((int)l) {
                case 9: 
                case 13: 
                case 32: {
                    long l3 = this.callWindowProc(this.handle, 256, l, l2);
                    return new LRESULT(l3);
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETDLGCODE(long l, long l2) {
        boolean bl;
        int n;
        int n2;
        LRESULT lRESULT = super.WM_GETDLGCODE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        long l3 = 0L;
        if (this.useCommonControl()) {
            LITEM lITEM = new LITEM();
            lITEM.mask = 3;
            lITEM.stateMask = 1;
            n2 = 0;
            while (OS.SendMessage(this.handle, 1795, 0L, lITEM) != 0L) {
                if ((lITEM.state & 1) != 0) {
                    n2 = lITEM.iLink;
                }
                ++lITEM.iLink;
            }
            n = lITEM.iLink;
            l3 = this.callWindowProc(this.handle, 135, l, l2);
        } else {
            n2 = this.focusIndex;
            n = this.offsets.length;
        }
        if (n == 0) {
            return new LRESULT(l3 | 0x100L);
        }
        boolean bl2 = bl = OS.GetKeyState(16) >= 0;
        if (bl && n2 < n - 1) {
            return new LRESULT(l3 | 2L);
        }
        if (!bl && n2 > 0) {
            return new LRESULT(l3 | 2L);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETFONT(long l, long l2) {
        LRESULT lRESULT = super.WM_GETFONT(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        long l3 = this.callWindowProc(this.handle, 49, l, l2);
        if (l3 != 0L) {
            return new LRESULT(l3);
        }
        if (this.font == 0L) {
            this.font = this.defaultFont();
        }
        return new LRESULT(this.font);
    }

    @Override
    LRESULT WM_KEYDOWN(long l, long l2) {
        LRESULT lRESULT = super.WM_KEYDOWN(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.useCommonControl()) {
            switch ((int)l) {
                case 9: 
                case 13: 
                case 32: {
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_KILLFOCUS(long l, long l2) {
        LRESULT lRESULT = super.WM_KILLFOCUS(l, l2);
        if (!this.useCommonControl()) {
            this.redraw();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (!this.useCommonControl()) {
            if (this.focusIndex != -1) {
                this.setFocus();
            }
            int n = OS.GET_X_LPARAM(l2);
            int n2 = OS.GET_Y_LPARAM(l2);
            int n3 = this.layout.getOffset(DPIUtil.autoScaleDown(n), DPIUtil.autoScaleDown(n2), null);
            int n4 = this.selection.x;
            int n5 = this.selection.y;
            this.selection.x = n3;
            this.selection.y = -1;
            if (n4 != -1 && n5 != -1) {
                if (n4 > n5) {
                    int n6 = n4;
                    n4 = n5;
                    n5 = n6;
                }
                Rectangle rectangle = DPIUtil.autoScaleUp(this.layout.getBounds(n4, n5));
                this.redrawInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            for (int i = 0; i < this.offsets.length; ++i) {
                Rectangle[] rectangleArray = this.getRectanglesInPixels(i);
                for (int j = 0; j < rectangleArray.length; ++j) {
                    Rectangle rectangle = rectangleArray[j];
                    if (!rectangle.contains(n, n2)) continue;
                    if (i != this.focusIndex) {
                        this.redraw();
                    }
                    this.focusIndex = this.mouseDownIndex = i;
                    return lRESULT;
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONUP(long l, long l2) {
        LRESULT lRESULT = super.WM_LBUTTONUP(l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (!this.useCommonControl()) {
            if (this.mouseDownIndex == -1) {
                return lRESULT;
            }
            int n = OS.GET_X_LPARAM(l2);
            int n2 = OS.GET_Y_LPARAM(l2);
            Rectangle[] rectangleArray = this.getRectanglesInPixels(this.mouseDownIndex);
            for (int i = 0; i < rectangleArray.length; ++i) {
                Rectangle rectangle = rectangleArray[i];
                if (!rectangle.contains(n, n2)) continue;
                Event event = new Event();
                event.text = this.ids[this.mouseDownIndex];
                this.sendSelectionEvent(13, event, true);
                break;
            }
        }
        this.mouseDownIndex = -1;
        return lRESULT;
    }

    @Override
    LRESULT WM_NCHITTEST(long l, long l2) {
        LRESULT lRESULT = super.WM_NCHITTEST(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(1L);
    }

    @Override
    LRESULT WM_MOUSEMOVE(long l, long l2) {
        LRESULT lRESULT = super.WM_MOUSEMOVE(l, l2);
        if (!this.useCommonControl()) {
            int n = OS.GET_X_LPARAM(l2);
            int n2 = OS.GET_Y_LPARAM(l2);
            if (OS.GetKeyState(1) < 0) {
                int n3 = this.selection.y;
                this.selection.y = this.layout.getOffset(DPIUtil.autoScaleDown(n), DPIUtil.autoScaleDown(n2), null);
                if (this.selection.y != n3) {
                    int n4 = this.selection.y;
                    if (n3 > n4) {
                        int n5 = n3;
                        n3 = n4;
                        n4 = n5;
                    }
                    Rectangle rectangle = DPIUtil.autoScaleUp(this.layout.getBounds(n3, n4));
                    this.redrawInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                }
            } else {
                for (int i = 0; i < this.offsets.length; ++i) {
                    Rectangle[] rectangleArray = this.getRectanglesInPixels(i);
                    for (int j = 0; j < rectangleArray.length; ++j) {
                        Rectangle rectangle = rectangleArray[j];
                        if (!rectangle.contains(n, n2)) continue;
                        this.setCursor(this.display.getSystemCursor(21));
                        return lRESULT;
                    }
                }
                this.setCursor(null);
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_PAINT(long l, long l2) {
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        if (this.useCommonControl()) {
            return super.WM_PAINT(l, l2);
        }
        PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
        GCData gCData = new GCData();
        gCData.ps = pAINTSTRUCT;
        gCData.hwnd = this.handle;
        GC gC = this.new_GC(gCData);
        if (gC != null) {
            int n = pAINTSTRUCT.right - pAINTSTRUCT.left;
            int n2 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
            if (n != 0 && n2 != 0) {
                RECT rECT = new RECT();
                OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                this.drawWidget(gC, rECT);
            }
            gC.dispose();
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_PRINTCLIENT(long l, long l2) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(l, l2);
        if (!this.useCommonControl()) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            GCData gCData = new GCData();
            gCData.device = this.display;
            gCData.foreground = this.getForegroundPixel();
            GC gC = GC.win32_new(l, gCData);
            this.drawWidget(gC, rECT);
            gC.dispose();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETFOCUS(long l, long l2) {
        LRESULT lRESULT = super.WM_SETFOCUS(l, l2);
        if (!this.useCommonControl()) {
            this.redraw();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETFONT(long l, long l2) {
        this.layout.setFont(Font.win32_new(this.display, l));
        if (l2 != 0L) {
            OS.InvalidateRect(this.handle, null, true);
        }
        this.font = l;
        return super.WM_SETFONT(this.font, l2);
    }

    @Override
    LRESULT WM_SIZE(long l, long l2) {
        LRESULT lRESULT = super.WM_SIZE(l, l2);
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        this.layout.setWidth(DPIUtil.autoScaleDown(rECT.right > 0 ? rECT.right : -1));
        if (!this.useCommonControl()) {
            this.redraw();
        }
        return lRESULT;
    }

    @Override
    LRESULT wmColorChild(long l, long l2) {
        LRESULT lRESULT = super.wmColorChild(l, l2);
        if (this.useCommonControl() && !OS.IsWindowEnabled(this.handle)) {
            OS.SetTextColor(l, OS.GetSysColor(OS.COLOR_GRAYTEXT));
            if (lRESULT == null) {
                int n = this.getBackgroundPixel();
                OS.SetBkColor(l, n);
                long l3 = this.findBrush(n, 0);
                return new LRESULT(l3);
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT wmNotifyChild(NMHDR nMHDR, long l, long l2) {
        if (this.useCommonControl()) {
            switch (nMHDR.code) {
                case -4: 
                case -2: {
                    NMLINK nMLINK = new NMLINK();
                    OS.MoveMemory(nMLINK, l2, NMLINK.sizeof);
                    Event event = new Event();
                    event.text = this.ids[nMLINK.iLink];
                    this.sendSelectionEvent(13, event, true);
                }
            }
        }
        return super.wmNotifyChild(nMHDR, l, l2);
    }

    static {
        LinkClass = new TCHAR(0, "SysLink", true);
        if (Link.isCommonControlAvailable()) {
            WNDCLASS wNDCLASS = new WNDCLASS();
            OS.GetClassInfo(0L, LinkClass, wNDCLASS);
            LinkProc = wNDCLASS.lpfnWndProc;
            long l = OS.GetModuleHandle(null);
            long l2 = OS.GetProcessHeap();
            wNDCLASS.hInstance = l;
            wNDCLASS.style &= 0xFFFFBFFF;
            wNDCLASS.style |= 8;
            int n = LinkClass.length() * TCHAR.sizeof;
            long l3 = OS.HeapAlloc(l2, 8, n);
            OS.MoveMemory(l3, LinkClass, n);
            wNDCLASS.lpszClassName = l3;
            OS.RegisterClass(wNDCLASS);
            OS.HeapFree(l2, 0, l3);
        } else {
            LinkProc = 0L;
        }
    }
}

