/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html.renderer;

import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;

public class ResolvedLink {
    private final LinkType myLinkType;
    private final String myUrl;
    private final LinkStatus myStatus;

    public ResolvedLink(LinkType linkType, CharSequence url) {
        this(linkType, url, LinkStatus.UNKNOWN);
    }

    public ResolvedLink(LinkType linkType, CharSequence url, LinkStatus status) {
        this.myLinkType = linkType;
        this.myUrl = url instanceof String ? (String)url : String.valueOf(url);
        this.myStatus = status;
    }

    public ResolvedLink withLinkType(LinkType linkType) {
        return linkType == this.myLinkType ? this : new ResolvedLink(linkType, this.myUrl, this.myStatus);
    }

    public ResolvedLink withStatus(LinkStatus status) {
        return status == this.myStatus ? this : new ResolvedLink(this.myLinkType, this.myUrl, status);
    }

    public ResolvedLink withUrl(CharSequence url) {
        String useUrl = url instanceof String ? (String)url : String.valueOf(url);
        return this.myUrl.equals(useUrl) ? this : new ResolvedLink(this.myLinkType, useUrl, this.myStatus);
    }

    public LinkType getLinkType() {
        return this.myLinkType;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public LinkStatus getStatus() {
        return this.myStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolvedLink)) {
            return false;
        }
        ResolvedLink link = (ResolvedLink)o;
        if (!this.myLinkType.equals(link.myLinkType)) {
            return false;
        }
        if (!this.myUrl.equals(link.myUrl)) {
            return false;
        }
        return this.myStatus.equals(link.myStatus);
    }

    public int hashCode() {
        int result = this.myLinkType.hashCode();
        result = 31 * result + this.myUrl.hashCode();
        result = 31 * result + this.myStatus.hashCode();
        return result;
    }
}

