/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.encoder.QuoteMode;

public class XMLEncoder
implements IEncoder {
    public static final String ESCAPEGT = "escapeGT";
    public static final String ESCAPENBSP = "escapeNbsp";
    public static final String ESCAPELINEBREAK = "escapeLineBreak";
    public static final String QUOTEMODEDEFINED = "quoteModeDefined";
    public static final String QUOTEMODE = "quoteMode";
    private CharsetEncoder chsEnc;
    private String lineBreak;
    private String encoding;
    private boolean escapeGT = false;
    private boolean escapeNbsp = false;
    private boolean escapeLineBreak = false;
    private QuoteMode quoteMode = QuoteMode.ALL;
    private IParameters params;

    public XMLEncoder(String encoding, String lineBreak, boolean escapeGT, boolean escapeNbsp, boolean escapeLineBreak, QuoteMode quoteMode) {
        this.escapeGT = escapeGT;
        this.escapeNbsp = escapeNbsp;
        this.escapeLineBreak = escapeLineBreak;
        this.quoteMode = quoteMode;
        this.setOptions(null, encoding, lineBreak);
    }

    public XMLEncoder() {
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.lineBreak = lineBreak;
        this.encoding = encoding;
        String enclc = encoding.toLowerCase();
        this.chsEnc = enclc.equals("utf-8") || enclc.startsWith("utf-16") ? null : Charset.forName(encoding).newEncoder();
        this.params = params;
        if (params != null) {
            this.escapeGT = params.getBoolean(ESCAPEGT);
            this.escapeNbsp = params.getBoolean(ESCAPENBSP);
            this.escapeLineBreak = params.getBoolean(ESCAPELINEBREAK);
            if (params.getBoolean(QUOTEMODEDEFINED)) {
                this.quoteMode = QuoteMode.fromValue(params.getInteger(QUOTEMODE));
            }
        }
    }

    @Override
    public String encode(String text, EncoderContext context) {
        if (text == null) {
            return "";
        }
        StringBuffer sbTmp = new StringBuffer(text.length());
        block3: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '>': {
                    if (this.escapeGT) {
                        sbTmp.append("&gt;");
                        continue block3;
                    }
                    if (i > 0 && text.charAt(i - 1) == ']') {
                        sbTmp.append("&gt;");
                        continue block3;
                    }
                    sbTmp.append('>');
                    continue block3;
                }
                default: {
                    if (ch > '\u007f' && Character.isHighSurrogate(ch)) {
                        int cp = text.codePointAt(i++);
                        String tmp = new String(Character.toChars(cp));
                        if (this.chsEnc != null && !this.chsEnc.canEncode(tmp)) {
                            sbTmp.append(String.format("&#x%x;", cp));
                            continue block3;
                        }
                        sbTmp.append(tmp);
                        continue block3;
                    }
                    sbTmp.append(this.encode(ch, context));
                }
            }
        }
        return sbTmp.toString();
    }

    @Override
    public String encode(char value, EncoderContext context) {
        switch (value) {
            case '<': {
                return "&lt;";
            }
            case '\"': {
                if (this.quoteMode != QuoteMode.UNESCAPED) {
                    return "&quot;";
                }
                return "\"";
            }
            case '\'': {
                switch (this.quoteMode) {
                    case ALL: {
                        return "&apos;";
                    }
                    case NUMERIC_SINGLE_QUOTES: {
                        return "&#39;";
                    }
                    case UNESCAPED: 
                    case DOUBLE_QUOTES_ONLY: {
                        return "'";
                    }
                }
            }
            case '&': {
                return "&amp;";
            }
            case '>': {
                if (this.escapeGT) {
                    return "&gt;";
                }
                return ">";
            }
            case '\r': {
                return "&#13;";
            }
            case '\n': {
                if (this.escapeLineBreak) {
                    return "&#10;";
                }
                return this.lineBreak;
            }
            case '\u00a0': {
                if (!this.escapeNbsp) break;
                return "&#x00a0;";
            }
        }
        if (value > '\u007f') {
            if (this.chsEnc != null && !this.chsEnc.canEncode(value)) {
                return String.format("&#x%04x;", value);
            }
            return String.valueOf(value);
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        if (Character.isSupplementaryCodePoint(value)) {
            String tmp = new String(Character.toChars(value));
            if (this.chsEnc != null && !this.chsEnc.canEncode(tmp)) {
                return String.format("&#x%x;", value);
            }
            return tmp;
        }
        return this.encode((char)value, context);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }
}

