/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource.simplifier;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.simplifier.IResourceSimplifier;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public abstract class AbstractResourceSimplifier
implements IResourceSimplifier {
    private IResourceSimplifier parent;
    private boolean multilingual;
    private LocaleId targetLocale;
    private String outputEncoding;
    private IFilterWriter filterWriter;
    private ISkeletonWriter skeletonWriter;
    private boolean isCollectingEvents;
    private boolean isReferentGroup;
    private Stack<Boolean> refGroupStack = new Stack();
    private String groupId;
    private MultiEvent group;

    protected abstract Event convertEvent(Event var1);

    private Event processEvent(Event event) {
        if (!this.isCollectingEvents || this.isReferentGroup) {
            return this.convertEvent(event);
        }
        Event ev = this.convertEvent(event);
        if (ev.isMultiEvent()) {
            for (Event e : ev.getMultiEvent()) {
                if (e.isNoop()) continue;
                this.group.addEvent(e);
            }
        } else {
            this.group.addEvent(ev);
        }
        return ev;
    }

    @Override
    public Event convert(Event event) {
        if (this.skeletonWriter == null) {
            return this.processEvent(event);
        }
        switch (event.getEventType()) {
            case START_GROUP: {
                this.isReferentGroup = event.getStartGroup().isReferent();
                if (this.isReferentGroup) {
                    this.skeletonWriter.processStartGroup(event.getStartGroup());
                }
                this.refGroupStack.push(this.isReferentGroup);
                event = this.processEvent(event);
                break;
            }
            case START_SUBFILTER: {
                StartSubfilter ssf = event.getStartSubfilter();
                this.isCollectingEvents = ssf.isReferent();
                if (this.isCollectingEvents) {
                    this.groupId = ssf.getId();
                    this.group = new MultiEvent();
                } else {
                    this.groupId = null;
                    this.group = null;
                }
                event = this.processEvent(event);
                break;
            }
            case END_GROUP: {
                if (this.isReferentGroup) {
                    this.skeletonWriter.processEndGroup(event.getEndGroup());
                }
                event = this.processEvent(event);
                this.refGroupStack.pop();
                this.isReferentGroup = this.refGroupStack.size() > 0 ? this.refGroupStack.peek() : false;
                break;
            }
            case END_SUBFILTER: {
                if (this.isCollectingEvents) {
                    this.processEvent(event);
                    this.setGroup(this.groupId, this.group);
                    return Event.NOOP_EVENT;
                }
                this.isCollectingEvents = false;
                break;
            }
            case TEXT_UNIT: {
                if (this.isReferentGroup) {
                    this.skeletonWriter.processTextUnit(event.getTextUnit());
                    return Event.NOOP_EVENT;
                }
                event = this.processEvent(event);
                break;
            }
            case DOCUMENT_PART: {
                if (this.isReferentGroup) {
                    this.skeletonWriter.processDocumentPart(event.getDocumentPart());
                    return Event.NOOP_EVENT;
                }
                event = this.processEvent(event);
                break;
            }
            default: {
                event = this.processEvent(event);
            }
        }
        return this.isCollectingEvents ? Event.NOOP_EVENT : event;
    }

    @Override
    public List<Event> convertToList(Event event) {
        LinkedList<Event> list = new LinkedList<Event>();
        Event me = this.convert(event);
        if (me.isMultiEvent()) {
            for (Event e : me.getMultiEvent()) {
                if (e.isNoop()) continue;
                list.add(e);
            }
        } else {
            list.add(me);
        }
        return list;
    }

    public IResourceSimplifier getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IResourceSimplifier parent) {
        this.parent = parent;
    }

    public boolean isMultilingual() {
        return this.multilingual;
    }

    @Override
    public void setMultilingual(boolean multilingual) {
        this.multilingual = multilingual;
    }

    public LocaleId getTargetLocale() {
        return this.targetLocale;
    }

    @Override
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    @Override
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public IFilterWriter getFilterWriter() {
        return this.filterWriter;
    }

    @Override
    public void setFilterWriter(IFilterWriter filterWriter) {
        this.filterWriter = filterWriter;
    }

    public ISkeletonWriter getSkeletonWriter() {
        return this.skeletonWriter;
    }

    @Override
    public void setSkeletonWriter(ISkeletonWriter skeletonWriter) {
        this.skeletonWriter = skeletonWriter;
    }

    @Override
    public void setGroup(String groupId, MultiEvent group) {
        if (this.parent != null) {
            this.parent.setGroup(groupId, group);
        }
    }

    @Override
    public MultiEvent getGroup(String groupId) {
        return this.parent == null ? null : this.parent.getGroup(groupId);
    }
}

