/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.IOException;
import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.Preferences;

class PreferencesParser {
    private static final QName XML_PREFERENCE = Namespaces.getDefaultNamespace().getQName("XMLPreference");
    private static final QName DEFAULT_STORY_TAG_NAME = Namespaces.getDefaultNamespace().getQName("DefaultStoryTagName");
    private static final QName DEFAULT_TABLE_TAG_NAME = Namespaces.getDefaultNamespace().getQName("DefaultTableTagName");
    private static final QName DEFAULT_CELL_TAG_NAME = Namespaces.getDefaultNamespace().getQName("DefaultCellTagName");
    private static final QName STORY_PREFERENCE = Namespaces.getDefaultNamespace().getQName("StoryPreference");
    private static final QName STORY_DIRECTION = Namespaces.getDefaultNamespace().getQName("StoryDirection");
    private final Reader reader;
    private final XMLInputFactory inputFactory;

    PreferencesParser(Reader reader, XMLInputFactory inputFactory) {
        this.reader = reader;
        this.inputFactory = inputFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Preferences parse() throws XMLStreamException, IOException {
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(this.reader);
        Preferences.PreferencesBuilder preferencesBuilder = new Preferences.PreferencesBuilder();
        try {
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement element = event.asStartElement();
                if (XML_PREFERENCE.equals(element.getName())) {
                    preferencesBuilder = this.parseXmlPreference(element, preferencesBuilder);
                    continue;
                }
                if (!STORY_PREFERENCE.equals(element.getName())) continue;
                preferencesBuilder = this.parseStoryPreference(element, preferencesBuilder);
            }
        }
        finally {
            this.reader.close();
        }
        return preferencesBuilder.build();
    }

    private Preferences.PreferencesBuilder parseXmlPreference(StartElement element, Preferences.PreferencesBuilder preferencesBuilder) {
        return preferencesBuilder.setXmlPreference(new Preferences.XMLPreference(element.getAttributeByName(DEFAULT_STORY_TAG_NAME).getValue(), element.getAttributeByName(DEFAULT_TABLE_TAG_NAME).getValue(), element.getAttributeByName(DEFAULT_CELL_TAG_NAME).getValue()));
    }

    private Preferences.PreferencesBuilder parseStoryPreference(StartElement element, Preferences.PreferencesBuilder preferencesBuilder) {
        return preferencesBuilder.setStoryPreference(new Preferences.StoryPreference(element.getAttributeByName(STORY_DIRECTION).getValue()));
    }
}

