/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openoffice;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.ZipFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openoffice.ODFFilter;
import net.sf.okapi.filters.openoffice.Parameters;

@UsingParameters(value=Parameters.class)
public class OpenOfficeFilter
implements IFilter {
    private File tempFile;
    private final String docId = "sd";
    private ZipFile zipFile;
    private ZipEntry entry;
    private NextAction nextAction;
    private URI docURI;
    private Enumeration<? extends ZipEntry> entries;
    private int subDocId;
    private LinkedList<Event> queue;
    private LocaleId srcLoc;
    private ODFFilter filter;
    private Parameters params = new Parameters();
    private String internalMimeType;
    private EncoderManager encoderManager;
    private RawDocument input;

    @Override
    public void cancel() {
        this.close();
    }

    @Override
    public void close() {
        if (this.filter != null) {
            this.filter.close();
        }
        if (this.input != null) {
            this.input.close();
        }
        try {
            this.nextAction = NextAction.DONE;
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return null;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new ZipFilterWriter(this.getEncoderManager());
    }

    @Override
    public String getName() {
        return "okf_openoffice";
    }

    @Override
    public String getDisplayName() {
        return "OpenOffice.org Filter (BETA)";
    }

    @Override
    public String getMimeType() {
        return "application/x-openoffice";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-openoffice", this.getClass().getName(), "OpenOffice.org Documents", "OpenOffice.org ODT, ODS, ODP, ODG, OTT, OTS, OTP, OTG documents", null, ".odt;.ods;.odg;.odp;.ott;.ots;.otp;.otg;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/x-odf", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.queue != null && !this.queue.isEmpty() || this.nextAction != NextAction.DONE;
    }

    @Override
    public Event next() {
        if (this.queue.size() > 0) {
            return this.queue.poll();
        }
        switch (this.nextAction) {
            case OPENZIP: {
                return this.openZipFile();
            }
            case NEXTINZIP: {
                return this.nextInZipFile();
            }
            case NEXTINSUBDOC: {
                return this.nextInSubDocument();
            }
        }
        throw new OkapiIllegalFilterOperationException("Invalid next() call.");
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.input = input;
        this.docURI = input.getInputURI();
        if (this.docURI == null) {
            this.tempFile = FileUtil.createTempFile("~okapi-23_OpenOfficeFilter_");
            StreamUtil.copy(input.getStream(), this.tempFile);
            this.docURI = Util.toURI(this.tempFile.getAbsolutePath());
        }
        this.nextAction = NextAction.OPENZIP;
        this.queue = new LinkedList();
        this.filter = new ODFFilter();
        this.filter.setParameters(this.params);
        this.srcLoc = input.getSourceLocale();
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
        if (this.filter != null) {
            this.filter.setParameters(params);
        }
    }

    private void getInternalMimeType() {
        try {
            this.internalMimeType = "";
            if (this.entries.hasMoreElements()) {
                ZipEntry entry = this.entries.nextElement();
                if (entry.getName().equals("mimetype")) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(this.zipFile.getInputStream(entry)));
                    this.internalMimeType = br.readLine();
                    this.internalMimeType = this.internalMimeType.trim();
                    br.close();
                }
                return;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error opening mimetype file.", e);
        }
        finally {
            this.entries = this.zipFile.entries();
        }
    }

    private Event openZipFile() {
        try {
            this.zipFile = new ZipFile(new File(this.docURI));
            this.entries = this.zipFile.entries();
            this.subDocId = 0;
            this.nextAction = NextAction.NEXTINZIP;
            this.getInternalMimeType();
            StartDocument startDoc = new StartDocument("sd");
            startDoc.setName(this.docURI.getPath());
            startDoc.setLocale(this.srcLoc);
            startDoc.setMimeType("application/x-openoffice");
            startDoc.setFilterParameters(this.params);
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setLineBreak("\n");
            startDoc.setEncoding("UTF-8", false);
            ZipSkeleton skel = new ZipSkeleton(this.zipFile, null);
            return new Event(EventType.START_DOCUMENT, startDoc, skel);
        }
        catch (ZipException e) {
            throw new OkapiIOException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private Event nextInZipFile() {
        if (this.entries.hasMoreElements()) {
            this.entry = this.entries.nextElement();
            if (this.entry.getName().equals("content.xml") || this.entry.getName().equals("meta.xml") || this.entry.getName().equals("styles.xml")) {
                return this.openSubDocument();
            }
            DocumentPart dp = new DocumentPart(this.entry.getName(), false);
            ZipSkeleton skel = new ZipSkeleton(this.zipFile, this.entry);
            return new Event(EventType.DOCUMENT_PART, dp, skel);
        }
        this.close();
        Ending ending = new Ending("ed");
        return new Event(EventType.END_DOCUMENT, ending);
    }

    private Event openSubDocument() {
        Event event;
        try {
            this.filter.open(new RawDocument(this.zipFile.getInputStream(this.entry), "UTF-8", this.srcLoc));
            event = this.filter.next();
            this.filter.setContainerMimeType(this.internalMimeType);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error opening internal file.", e);
        }
        StartSubDocument sd = new StartSubDocument("sd", String.valueOf(++this.subDocId));
        sd.setName(this.docURI.getPath() + "/" + this.entry.getName());
        this.nextAction = NextAction.NEXTINSUBDOC;
        ZipSkeleton skel = new ZipSkeleton((GenericSkeleton)event.getResource().getSkeleton(), this.zipFile, this.entry);
        return new Event(EventType.START_SUBDOCUMENT, sd, skel);
    }

    private Event nextInSubDocument() {
        if (this.filter.hasNext()) {
            Event event = this.filter.next();
            switch (event.getEventType()) {
                case END_DOCUMENT: {
                    Ending ending = new Ending(String.valueOf(this.subDocId));
                    this.nextAction = NextAction.NEXTINZIP;
                    ZipSkeleton skel = new ZipSkeleton((GenericSkeleton)event.getResource().getSkeleton(), this.zipFile, this.entry);
                    this.filter.close();
                    return new Event(EventType.END_SUBDOCUMENT, ending, skel);
                }
            }
            return event;
        }
        return null;
    }

    private static enum NextAction {
        OPENZIP,
        NEXTINZIP,
        NEXTINSUBDOC,
        DONE;

    }
}

