/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.MergeableRunProperty;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.StyledText;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class RunMerger {
    private static final String LATIN_CHARACTER_SELECTOR = ".*[\u0000-\u007f\u0080-\u00a6\u00a9-\u00af\u00b2-\u00b3\u00b5-\u00d6\u00d8-\u00f6\u00f8-\u058f\u10a0-\u10ff\u1200-\u137f\u13a0-\u177f\u1d00-\u1d7f\u1e00-\u1fff\u2000-\u202b\u2030-\u2046\u204a-\u245f\u27c0-\u2bff\ufb00-\ufb17\ufe50-\ufe6f\ud835].*";
    private static final String COMPLEX_SCRIPT_CHARACTER_SELECTOR = ".*[\u0590-\u074f\u0780-\u07bf\u0900-\u109f\u1780-\u18af\u200f-\u200f\u202a-\u202f\u2670-\u2671\ufb1d-\ufb4f].*";
    private static final String EAST_ASIA_CHARACTER_SELECTOR = ".*[\u3099-\u309a].*";
    private static final String QUOTATION_CHARACTERS_EAST_ASIA = ".*[\u2010-\u2029].*";
    private static final List<LocaleId> EAST_ASIAN_REGIONS_BY_LANGUAGES = Arrays.asList(LocaleId.fromBCP47("ii-CN"), LocaleId.fromBCP47("ja-JP"), LocaleId.fromBCP47("ko-KR"), LocaleId.fromBCP47("zh-CN"), LocaleId.fromBCP47("zh-HK"), LocaleId.fromBCP47("zh-MO"), LocaleId.fromBCP47("zh-SG"), LocaleId.fromBCP47("zh-TW"));
    private String paragraphStyle;
    private RunBuilder previousRunBuilder;
    private List<Block.BlockChunk> completedRuns = new ArrayList<Block.BlockChunk>();

    RunMerger() {
    }

    void setParagraphStyle(String paragraphStyle) {
        this.paragraphStyle = paragraphStyle;
    }

    List<Block.BlockChunk> getRuns() throws XMLStreamException {
        if (this.previousRunBuilder != null) {
            this.completedRuns.add(this.previousRunBuilder.build());
            this.previousRunBuilder = null;
        }
        return this.completedRuns;
    }

    void add(RunBuilder runBuilder) throws XMLStreamException {
        if (null == this.previousRunBuilder) {
            runBuilder.resetCombinedRunProperties(this.paragraphStyle);
            this.previousRunBuilder = runBuilder;
            return;
        }
        if (this.canMerge(this.previousRunBuilder, runBuilder)) {
            this.merge(this.previousRunBuilder, runBuilder);
        } else {
            this.completedRuns.add(this.previousRunBuilder.build());
            this.previousRunBuilder = runBuilder;
        }
    }

    private boolean canMerge(RunBuilder runBuilder, RunBuilder otherRunBuilder) {
        RunProperties combinedRunProperties = runBuilder.getCombinedRunProperties(this.paragraphStyle);
        RunProperties combinedOtherRunProperties = otherRunBuilder.getCombinedRunProperties(this.paragraphStyle);
        if (runBuilder.isHidden() || otherRunBuilder.isHidden()) {
            return false;
        }
        if (Namespaces.Math.containsName(runBuilder.getStartElementContext().getStartElement().getName())) {
            return false;
        }
        if (runBuilder.containsNestedItems() || otherRunBuilder.containsNestedItems()) {
            return false;
        }
        if (runBuilder.hasComplexCodes() || otherRunBuilder.hasComplexCodes()) {
            return false;
        }
        this.detectRunFontsContentCategories(runBuilder, combinedRunProperties);
        this.detectRunFontsContentCategories(otherRunBuilder, combinedOtherRunProperties);
        return this.canRunPropertiesBeMerged(combinedRunProperties, combinedOtherRunProperties);
    }

    private void detectRunFontsContentCategories(RunBuilder runBuilder, RunProperties combinedRunProperties) {
        LocaleId sourceLanguage = runBuilder.getStartElementContext().getSourceLanguage();
        String runText = runBuilder.getRunText();
        if (runText == null) {
            return;
        }
        for (RunProperty runProperty : combinedRunProperties.getProperties()) {
            if (!(runProperty instanceof RunProperty.FontsRunProperty)) continue;
            RunProperty.FontsRunProperty fontsRunProperty = (RunProperty.FontsRunProperty)runProperty;
            RunFonts runFonts = fontsRunProperty.getRunFonts();
            List<RunFonts.ContentCategory> contentCategories = this.detectAndGetRunFontsContentCategories(sourceLanguage, runText, runFonts);
            runFonts.setDetectedContentCategories(contentCategories);
        }
    }

    private List<RunFonts.ContentCategory> detectAndGetRunFontsContentCategories(LocaleId sourceLanguage, String runText, RunFonts runFonts) {
        ArrayList<RunFonts.ContentCategory> detectedContentCategories = new ArrayList<RunFonts.ContentCategory>();
        if (runText.matches(".*\\p{ASCII}.*")) {
            detectedContentCategories.add(runFonts.getContentCategory(RunFonts.ContentCategory.ASCII_THEME, RunFonts.ContentCategory.ASCII));
        }
        if (runText.matches(LATIN_CHARACTER_SELECTOR) && runText.matches(".*[^\\p{ASCII}].*")) {
            detectedContentCategories.add(runFonts.getContentCategory(RunFonts.ContentCategory.HIGH_ANSI_THEME, RunFonts.ContentCategory.HIGH_ANSI));
        }
        if (runText.matches(EAST_ASIA_CHARACTER_SELECTOR) || this.containsQuotationsInEastAsianLanguage(runText, sourceLanguage) || this.containsOtherCharacters(runText)) {
            detectedContentCategories.add(runFonts.getContentCategory(RunFonts.ContentCategory.EAST_ASIAN_THEME, RunFonts.ContentCategory.EAST_ASIAN));
        }
        if (runText.matches(COMPLEX_SCRIPT_CHARACTER_SELECTOR)) {
            detectedContentCategories.add(runFonts.getContentCategory(RunFonts.ContentCategory.COMPLEX_SCRIPT_THEME, RunFonts.ContentCategory.COMPLEX_SCRIPT));
        }
        return detectedContentCategories;
    }

    private boolean containsQuotationsInEastAsianLanguage(String runText, LocaleId sourceLanguage) {
        return EAST_ASIAN_REGIONS_BY_LANGUAGES.contains(sourceLanguage) && runText.matches(QUOTATION_CHARACTERS_EAST_ASIA);
    }

    private boolean containsOtherCharacters(String runText) {
        return !runText.matches(LATIN_CHARACTER_SELECTOR) && !runText.matches(COMPLEX_SCRIPT_CHARACTER_SELECTOR) && !runText.matches(QUOTATION_CHARACTERS_EAST_ASIA) && !runText.matches(EAST_ASIA_CHARACTER_SELECTOR);
    }

    private boolean canRunPropertiesBeMerged(RunProperties currentProperties, RunProperties otherProperties) {
        if (currentProperties.count() != otherProperties.count()) {
            return false;
        }
        int numberOfMatchedProperties = 0;
        block0: for (RunProperty currentProperty : currentProperties.getProperties()) {
            QName currentPropertyStartElementName = currentProperty.getName();
            for (RunProperty otherProperty : otherProperties.getProperties()) {
                QName otherPropertyStartElementName = otherProperty.getName();
                if (!currentPropertyStartElementName.equals(otherPropertyStartElementName)) continue;
                if (currentProperty instanceof MergeableRunProperty && otherProperty instanceof MergeableRunProperty ? !((MergeableRunProperty)((Object)currentProperty)).canBeMerged((MergeableRunProperty)((Object)otherProperty)) : !currentProperty.canBeReplaced(otherProperty)) {
                    return false;
                }
                ++numberOfMatchedProperties;
                continue block0;
            }
        }
        return numberOfMatchedProperties >= currentProperties.count();
    }

    private void merge(RunBuilder runBuilder, RunBuilder otherRunBuilder) throws XMLStreamException {
        runBuilder.setRunProperties(this.mergeRunProperties(runBuilder.getRunProperties(), otherRunBuilder.getRunProperties(), runBuilder.getCombinedRunProperties(this.paragraphStyle), otherRunBuilder.getCombinedRunProperties(this.paragraphStyle)));
        runBuilder.resetCombinedRunProperties(this.paragraphStyle);
        ArrayList<XMLEvent> newBodyEvents = new ArrayList<XMLEvent>();
        XMLEventHelpers.addChunksToList(newBodyEvents, runBuilder.getRunBodyChunks());
        runBuilder.setTextPreservingWhitespace(runBuilder.isTextPreservingWhitespace() || otherRunBuilder.isTextPreservingWhitespace());
        XMLEventHelpers.addChunksToList(newBodyEvents, otherRunBuilder.getRunBodyChunks());
        runBuilder.getRunBodyChunks().clear();
        XMLListEventReader events = new XMLListEventReader(newBodyEvents);
        while (events.hasNext()) {
            runBuilder.addRunBody(events.nextEvent(), events);
        }
        runBuilder.flushText();
        runBuilder.flushMarkupChunk();
    }

    private RunProperties mergeRunProperties(RunProperties runProperties, RunProperties otherRunProperties, RunProperties combinedRunProperties, RunProperties otherCombinedRunProperties) {
        List<RunProperty> mergeableRunProperties = runProperties.getMergeableRunProperties();
        List<RunProperty> otherMergeableRunProperties = otherRunProperties.getMergeableRunProperties();
        if (mergeableRunProperties.isEmpty() && otherMergeableRunProperties.isEmpty()) {
            return runProperties.count() <= otherRunProperties.count() ? runProperties : otherRunProperties;
        }
        if (mergeableRunProperties.size() >= otherMergeableRunProperties.size()) {
            List<RunProperty> remainedOtherMergeableRunProperties = this.mergeMergeableRunProperties(mergeableRunProperties, otherMergeableRunProperties);
            runProperties.getProperties().addAll(remainedOtherMergeableRunProperties);
            this.clarifyFontsRunProperties(runProperties, this.mergeCombinedRunProperties(combinedRunProperties, otherCombinedRunProperties));
            return runProperties;
        }
        List<RunProperty> remainedMergeableRunProperties = this.mergeMergeableRunProperties(otherMergeableRunProperties, mergeableRunProperties);
        otherRunProperties.getProperties().addAll(remainedMergeableRunProperties);
        this.clarifyFontsRunProperties(otherRunProperties, this.mergeCombinedRunProperties(combinedRunProperties, otherCombinedRunProperties));
        return otherRunProperties;
    }

    private RunProperties mergeCombinedRunProperties(RunProperties combinedRunProperties, RunProperties otherCombinedRunProperties) {
        List<RunProperty> mergeableCombinedRunProperties = combinedRunProperties.getMergeableRunProperties();
        List<RunProperty> otherMergeableCombinedRunProperties = otherCombinedRunProperties.getMergeableRunProperties();
        if (mergeableCombinedRunProperties.size() >= otherMergeableCombinedRunProperties.size()) {
            List<RunProperty> remainedOtherMergeableCombinedRunProperties = this.mergeMergeableRunProperties(mergeableCombinedRunProperties, otherMergeableCombinedRunProperties);
            combinedRunProperties.getProperties().addAll(remainedOtherMergeableCombinedRunProperties);
            return combinedRunProperties;
        }
        List<RunProperty> remainedMergeableCombinedRunProperties = this.mergeMergeableRunProperties(otherMergeableCombinedRunProperties, mergeableCombinedRunProperties);
        otherCombinedRunProperties.getProperties().addAll(remainedMergeableCombinedRunProperties);
        return otherCombinedRunProperties;
    }

    private List<RunProperty> mergeMergeableRunProperties(List<RunProperty> mergeableRunProperties, List<RunProperty> otherMergeableRunProperties) {
        ArrayList<RunProperty> remainedOtherMergeableRunProperties = new ArrayList<RunProperty>(otherMergeableRunProperties);
        block0: for (RunProperty runProperty : mergeableRunProperties) {
            QName currentPropertyStartElementName = runProperty.getName();
            Iterator remainedOtherMergeableRunPropertyIterator = remainedOtherMergeableRunProperties.iterator();
            while (remainedOtherMergeableRunPropertyIterator.hasNext()) {
                RunProperty otherRunProperty = (RunProperty)remainedOtherMergeableRunPropertyIterator.next();
                QName otherPropertyStartElementName = otherRunProperty.getName();
                if (!currentPropertyStartElementName.equals(otherPropertyStartElementName)) continue;
                ((MergeableRunProperty)((Object)runProperty)).merge((MergeableRunProperty)((Object)otherRunProperty));
                remainedOtherMergeableRunPropertyIterator.remove();
                continue block0;
            }
        }
        return remainedOtherMergeableRunProperties;
    }

    private void clarifyFontsRunProperties(RunProperties runProperties, RunProperties combinedRunProperties) {
        for (RunProperty combinedRunProperty : combinedRunProperties.getProperties()) {
            if (!(combinedRunProperty instanceof RunProperty.FontsRunProperty)) continue;
            ListIterator<RunProperty> runPropertyIterator = runProperties.getProperties().listIterator();
            while (runPropertyIterator.hasNext()) {
                RunProperty runProperty = runPropertyIterator.next();
                if (!(runProperty instanceof RunProperty.FontsRunProperty)) continue;
                runPropertyIterator.set(combinedRunProperty);
                return;
            }
            runPropertyIterator.add(combinedRunProperty);
            return;
        }
    }

    void reset() {
        this.completedRuns.clear();
        this.previousRunBuilder = null;
    }

    public void append(char c) throws XMLStreamException {
        List<Chunk> bodyChunks = this.previousRunBuilder.getRunBodyChunks();
        for (Chunk chunk : bodyChunks) {
            if (!(chunk instanceof StyledText)) continue;
            StyledText styledText = (StyledText)chunk;
            String text = styledText.getText();
            styledText.setText(this.previousRunBuilder.getStartElementContext().getEventFactory().createCharacters(text + String.valueOf(c)));
        }
    }

    class XMLListEventReader
    implements XMLEventReader {
        private Iterator<XMLEvent> events;

        XMLListEventReader(Iterable<XMLEvent> events) {
            this.events = events.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.events.hasNext();
        }

        @Override
        public XMLEvent nextEvent() {
            return this.events.next();
        }

        @Override
        public void remove() {
            this.events.remove();
        }

        @Override
        public XMLEvent nextTag() throws XMLStreamException {
            XMLEvent e = this.nextEvent();
            while (e != null) {
                if (e.isStartElement() || e.isEndElement()) {
                    return e;
                }
                if (!XMLEventHelpers.isWhitespace(e)) {
                    throw new IllegalStateException("Unexpected event: " + e);
                }
                e = this.nextEvent();
            }
            return null;
        }

        @Override
        public XMLEvent peek() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getElementText() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws XMLStreamException {
        }

        @Override
        public Object next() {
            return this.events.next();
        }
    }
}

