/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.lib.beans.v1.AnnotationsBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;
import net.sf.okapi.lib.persistence.beans.FactoryBean;

public class RawDocumentBean
extends PersistenceBean<RawDocument> {
    private AnnotationsBean annotations = new AnnotationsBean();
    private String filterConfigId;
    private String id;
    private String encoding;
    private String srcLoc;
    private String trgLoc;
    private String inputURI;
    private String inputCharSequence;

    @Override
    protected RawDocument createObject(IPersistenceSession session) {
        RawDocument obj = null;
        if (!Util.isEmpty(this.inputURI)) {
            try {
                obj = new RawDocument(new URI(this.inputURI), this.encoding, LocaleId.fromString(this.srcLoc), LocaleId.fromString(this.trgLoc));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            obj = !Util.isEmpty(this.inputCharSequence) ? new RawDocument(this.inputCharSequence, LocaleId.fromString(this.srcLoc), LocaleId.fromString(this.trgLoc)) : new RawDocument("", LocaleId.fromString(this.srcLoc), LocaleId.fromString(this.trgLoc));
        }
        return obj;
    }

    @Override
    protected void fromObject(RawDocument obj, IPersistenceSession session) {
        this.annotations.set(obj.getAnnotations(), session);
        this.filterConfigId = obj.getFilterConfigId();
        this.id = obj.getId();
        this.encoding = obj.getEncoding();
        if (obj.getSourceLocale() != null) {
            this.srcLoc = obj.getSourceLocale().toString();
        }
        if (obj.getTargetLocale() != null) {
            this.trgLoc = obj.getTargetLocale().toString();
        }
        if (obj.getInputURI() != null) {
            this.inputURI = obj.getInputURI().toString();
        }
        if (obj.getInputCharSequence() != null) {
            this.inputCharSequence = obj.getInputCharSequence().toString();
        }
    }

    @Override
    protected void setObject(RawDocument obj, IPersistenceSession session) {
        for (FactoryBean annotationBean : this.annotations.getItems()) {
            obj.setAnnotation(annotationBean.get(IAnnotation.class, session));
        }
        obj.setFilterConfigId(this.filterConfigId);
        obj.setId(this.id);
        obj.setEncoding(this.encoding);
    }

    public AnnotationsBean getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationsBean annotations) {
        this.annotations = annotations;
    }

    public String getFilterConfigId() {
        return this.filterConfigId;
    }

    public void setFilterConfigId(String filterConfigId) {
        this.filterConfigId = filterConfigId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getSrcLoc() {
        return this.srcLoc;
    }

    public void setSrcLoc(String srcLoc) {
        this.srcLoc = srcLoc;
    }

    public String getTrgLoc() {
        return this.trgLoc;
    }

    public void setTrgLoc(String trgLoc) {
        this.trgLoc = trgLoc;
    }

    public String getInputURI() {
        return this.inputURI;
    }

    public void setInputURI(String inputURI) {
        this.inputURI = inputURI;
    }

    public String getInputCharSequence() {
        return this.inputCharSequence;
    }

    public void setInputCharSequence(String inputCharSequence) {
        this.inputCharSequence = inputCharSequence;
    }
}

