/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.persistence;

import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.persistence.BeanList;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanMap {
    private static final Logger logger = LoggerFactory.getLogger(BeanList.class);

    public static <E, S extends E, T extends IPersistenceBean<E>, U> void set(Map<U, T> beanMap, Class<T> beanClass, Map<U, S> objMap, IPersistenceSession session) {
        if (objMap == null) {
            return;
        }
        for (U key : objMap.keySet()) {
            S obj = objMap.get(key);
            IPersistenceBean bean = null;
            try {
                bean = (IPersistenceBean)beanClass.newInstance();
                bean.set(obj, session);
                beanMap.put(key, bean);
            }
            catch (Exception e) {
                logger.error("Failed to create bean '{}' for '{}'.", (Object)ClassUtil.getQualifiedClassName(bean), (Object)ClassUtil.getQualifiedClassName(obj));
                throw new OkapiException(e);
            }
        }
    }

    public static <E, S extends E, T extends IPersistenceBean<E>, U> Map<U, S> get(Map<U, T> beanMap, Class<S> objClass, IPersistenceSession session) {
        HashMap<U, S> objMap = new HashMap<U, S>();
        for (U key : beanMap.keySet()) {
            IPersistenceBean bean = (IPersistenceBean)beanMap.get(key);
            S obj = bean.get(objClass, session);
            objMap.put(key, obj);
        }
        return objMap;
    }
}

