/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.tkit.jarswitcher;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.okapi.common.exceptions.OkapiIOException;

public class VersionInfo
implements Comparable<VersionInfo> {
    private static final SimpleDateFormat LONG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
    private static final SimpleDateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private String label;
    private String path;
    private String date;

    public VersionInfo() {
    }

    public VersionInfo(String label, String path, String date) {
        this.label = label;
        this.path = path;
        this.date = date;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @Override
    public int compareTo(VersionInfo vi) {
        try {
            Date d = VersionInfo.parseShortDate(this.date);
            Date d2 = VersionInfo.parseShortDate(vi.getDate());
            return d.compareTo(d2);
        }
        catch (ParseException e) {
            return 0;
        }
    }

    public static Date parseLongDate(String date) throws ParseException {
        return LONG_DATE_FORMAT.parse(date);
    }

    public static Date parseShortDate(String date) throws ParseException {
        return SHORT_DATE_FORMAT.parse(date);
    }

    public static String getFileCreationDate(URL url) {
        try {
            return VersionInfo.getFileCreationDate(new File(url.toURI()));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String getFileCreationDate(String path) {
        return VersionInfo.getFileCreationDate(new File(path));
    }

    public static String getFileCreationDate(File file) {
        Path path = file.toPath();
        try {
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            FileTime creationTime = attr.creationTime();
            long mils = creationTime.toMillis();
            Date d = new Date(mils);
            String date = SHORT_DATE_FORMAT.format(d);
            return date;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }
}

