/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import com.ibm.icu.lang.UCharacter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.verification.BlackTerm;
import net.sf.okapi.lib.verification.BlacklistTB;
import net.sf.okapi.lib.verification.Issue;

public class BlacklistChecker {
    private ArrayList<Issue> issues;
    private BlacklistTB ta;
    private LocaleId loc = new LocaleId(Locale.getDefault());

    public void initialize(BlacklistTB termAccess) {
        this.issues = new ArrayList();
        this.ta = termAccess;
    }

    public void initialize(BlacklistTB termAccess, LocaleId loc) {
        this.initialize(termAccess);
        this.loc = loc;
    }

    public int verify(URI docId, String subDocId, ITextUnit tu, Segment segment, boolean allowBlacklistSub, boolean isSrc) {
        this.issues.clear();
        List<BlackTerm> termList = this.ta.getBlacklistStrings();
        List<Integer> mrkPositions = new ArrayList<Integer>();
        String searchTxtAsIs = TextUnitUtil.getText(segment.getContent(), mrkPositions);
        String searchTxtUpperCase = UCharacter.toUpperCase(this.loc.toIcuLocale(), searchTxtAsIs);
        mrkPositions = this.updateMarkerPositions(mrkPositions);
        for (BlackTerm bterm : termList) {
            String search = bterm.doCaseSensitiveMatch ? searchTxtAsIs : searchTxtUpperCase;
            int idx = 0;
            while ((idx = search.indexOf(bterm.searchTerm, idx)) != -1 && (bterm.searchTerm.length() == search.length() || allowBlacklistSub || !(idx <= 0 || idx >= search.length() - bterm.searchTerm.length() ? (idx != 0 ? Character.isLetter(search.charAt(idx - 1)) : Character.isLetter(search.charAt(idx + bterm.searchTerm.length()))) : Character.isLetter(search.charAt(idx - 1)) || Character.isLetter(search.charAt(idx + bterm.searchTerm.length()))))) {
                int rangeEnd;
                int rangeStart;
                if (!mrkPositions.isEmpty()) {
                    int offset = this.getOffset(idx, mrkPositions, true);
                    rangeStart = idx + offset;
                    rangeEnd = idx + bterm.searchTerm.length();
                    offset = this.getOffset(rangeEnd, mrkPositions, false);
                    rangeEnd += offset;
                } else {
                    rangeStart = idx;
                    rangeEnd = rangeStart + bterm.searchTerm.length();
                }
                String message = !bterm.suggestion.isEmpty() ? String.format("The term \"%s\" is a blacklisted term. Consider using \"%s\".", bterm.text, bterm.suggestion) : String.format("The term \"%s\" is a blacklisted term. Consider revising.", bterm.text);
                Issue issue = isSrc ? new Issue(docId, subDocId, IssueType.TERMINOLOGY, tu.getId(), segment.getId(), message, TextFragment.fromFragmentToString(segment.text, rangeStart), TextFragment.fromFragmentToString(segment.text, rangeEnd), 0, -1, 0.0, tu.getName()) : new Issue(docId, subDocId, IssueType.TERMINOLOGY, tu.getId(), segment.getId(), message, 0, -1, TextFragment.fromFragmentToString(segment.text, rangeStart), TextFragment.fromFragmentToString(segment.text, rangeEnd), 0.0, tu.getName());
                this.issues.add(issue);
                ++idx;
            }
        }
        return this.issues.size();
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    private List<Integer> updateMarkerPositions(List<Integer> mrkPositions) {
        for (int i = 0; i < mrkPositions.size(); ++i) {
            int value = mrkPositions.get(i);
            mrkPositions.set(i, value -= i * 2);
        }
        return mrkPositions;
    }

    private int getOffset(int index, List<Integer> mrkPositions, boolean isStart) {
        int offset = 0;
        for (int i = 0; i < mrkPositions.size(); ++i) {
            if (mrkPositions.get(i) < index) {
                ++offset;
                continue;
            }
            if (mrkPositions.get(i) == index && isStart) {
                ++offset;
                continue;
            }
            if (mrkPositions.get(i) <= index) continue;
            return offset * 2;
        }
        return offset * 2;
    }
}

