/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class ConstrainedSashForm
extends SashForm {
    private Sash sash;
    private Control upPart;
    private Control dnPart;
    private int wDelta;
    private int hDelta;
    private int min1;
    private int min2;
    private Rectangle sr;

    public ConstrainedSashForm(Composite parent, final boolean verticalSash) {
        super(parent, verticalSash ? 256 : 512);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                Rectangle r0 = ConstrainedSashForm.this.getParent().getBounds();
                Rectangle r1 = ConstrainedSashForm.this.getBounds();
                ConstrainedSashForm.this.wDelta = r0.width - r1.width;
                ConstrainedSashForm.this.hDelta = r0.height - r1.height;
                for (Control child : ConstrainedSashForm.this.getChildren()) {
                    if (!(child instanceof Sash)) continue;
                    ConstrainedSashForm.this.sash = (Sash)child;
                    ConstrainedSashForm.this.sash.addListener(13, new Listener(){

                        @Override
                        public void handleEvent(Event event) {
                            Rectangle rect = ConstrainedSashForm.this.sash.getParent().getClientArea();
                            if (verticalSash) {
                                event.x = event.x < rect.width / 2 ? Math.max(ConstrainedSashForm.this.min1, event.x) : Math.min(rect.width - ConstrainedSashForm.this.min2, event.x);
                            } else {
                                int n = event.y = event.y < rect.height / 2 ? Math.max(ConstrainedSashForm.this.min1, event.y) : Math.min(rect.height - ConstrainedSashForm.this.min2, event.y);
                            }
                            if (event.detail != 1) {
                                Rectangle r0 = ConstrainedSashForm.this.sash.getParent().getClientArea();
                                Rectangle r1 = ConstrainedSashForm.this.upPart.getBounds();
                                Rectangle r2 = ConstrainedSashForm.this.sash.getBounds();
                                Rectangle r3 = ConstrainedSashForm.this.dnPart.getBounds();
                                if (verticalSash) {
                                    int ltWidth = event.x;
                                    int rtWidth = r0.width - (ltWidth + r2.width);
                                    ConstrainedSashForm.this.upPart.setBounds(r1.x, r1.y, ltWidth, r1.height);
                                    ConstrainedSashForm.this.sash.setBounds(ltWidth, r2.y, r2.width, r2.height);
                                    ConstrainedSashForm.this.dnPart.setBounds(ltWidth + r2.width, r3.y, rtWidth, r3.height);
                                } else {
                                    int upHeight = event.y;
                                    int dnHeight = r0.height - (upHeight + r2.height);
                                    ConstrainedSashForm.this.upPart.setBounds(r1.x, r1.y, r1.width, upHeight);
                                    ConstrainedSashForm.this.sash.setBounds(r2.x, upHeight, r2.width, r2.height);
                                    ConstrainedSashForm.this.dnPart.setBounds(r3.x, upHeight + r2.height, r3.width, dnHeight);
                                }
                            }
                        }
                    });
                    Control[] children = ConstrainedSashForm.this.getChildren();
                    if (children.length <= 1) break;
                    ConstrainedSashForm.this.upPart = children[0];
                    ConstrainedSashForm.this.dnPart = children[1];
                    Point p1 = ConstrainedSashForm.this.upPart.computeSize(-1, -1);
                    Point p2 = ConstrainedSashForm.this.dnPart.computeSize(-1, -1);
                    if (verticalSash) {
                        ConstrainedSashForm.this.min1 = p1.x;
                        ConstrainedSashForm.this.min2 = p2.x;
                        ConstrainedSashForm.this.setWeights(new int[]{ConstrainedSashForm.this.min1, ConstrainedSashForm.this.min2});
                        break;
                    }
                    ConstrainedSashForm.this.min1 = p1.y;
                    ConstrainedSashForm.this.min2 = p2.y;
                    ConstrainedSashForm.this.setWeights(new int[]{ConstrainedSashForm.this.min1, ConstrainedSashForm.this.min2});
                    break;
                }
            }
        });
        this.addListener(11, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (ConstrainedSashForm.this.sash == null) {
                    return;
                }
                Rectangle rect = ConstrainedSashForm.this.sash.getParent().getClientArea();
                ConstrainedSashForm.this.sr = ConstrainedSashForm.this.sash.getBounds();
                if (verticalSash) {
                    ((ConstrainedSashForm)ConstrainedSashForm.this).sr.x = ((ConstrainedSashForm)ConstrainedSashForm.this).sr.x < rect.width / 2 ? Math.max(ConstrainedSashForm.this.min1, ((ConstrainedSashForm)ConstrainedSashForm.this).sr.x) : Math.min(rect.width - ConstrainedSashForm.this.min2, ((ConstrainedSashForm)ConstrainedSashForm.this).sr.x);
                    ConstrainedSashForm.this.setWeights(new int[]{((ConstrainedSashForm)ConstrainedSashForm.this).sr.x, rect.width - ((ConstrainedSashForm)ConstrainedSashForm.this).sr.x});
                } else {
                    ((ConstrainedSashForm)ConstrainedSashForm.this).sr.y = ((ConstrainedSashForm)ConstrainedSashForm.this).sr.y < rect.height / 2 ? Math.max(ConstrainedSashForm.this.min1, ((ConstrainedSashForm)ConstrainedSashForm.this).sr.y) : Math.min(rect.height - ConstrainedSashForm.this.min2, ((ConstrainedSashForm)ConstrainedSashForm.this).sr.y);
                    ConstrainedSashForm.this.setWeights(new int[]{((ConstrainedSashForm)ConstrainedSashForm.this).sr.y, rect.height - ((ConstrainedSashForm)ConstrainedSashForm.this).sr.y});
                }
                Rectangle r0 = ConstrainedSashForm.this.getParent().getBounds();
                Rectangle r1 = ConstrainedSashForm.this.getBounds();
                if (r0.width - r1.width != ConstrainedSashForm.this.wDelta || r0.height - r1.height != ConstrainedSashForm.this.hDelta) {
                    ConstrainedSashForm.this.setBounds(r1.x, r1.y, r0.width - ConstrainedSashForm.this.wDelta, r0.height - ConstrainedSashForm.this.hDelta);
                }
            }
        });
    }
}

