/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Scanner;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.io.FileCachedInputStream;

public class StreamUtil {
    /*
     * Loose catch block
     */
    public static byte[] inputStreamToBytes(InputStream in) throws IOException {
        try {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream(1024);){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, len);
                }
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void copy(File in, OutputStream out) {
        try {
            Files.copy(in.toPath(), out);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public static String streamAsString(InputStream in, String encoding) {
        try (Scanner s = new Scanner(in, encoding);){
            s.useDelimiter("\\A");
            String tmp = s.hasNext() ? s.next() : "";
            String string = Util.normalizeNewlines(tmp.toString());
            return string;
        }
    }

    public static String streamUtf8AsString(InputStream in) {
        return StreamUtil.streamAsString(in, "UTF-8");
    }

    public static InputStream stringAsStream(String str, String encoding) {
        try {
            return new ByteArrayInputStream(str.getBytes(encoding));
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public static long calcCRC(InputStream in) {
        CheckedInputStream cis = new CheckedInputStream(in, new CRC32());
        byte[] buf = new byte[1024];
        try {
            while (cis.read(buf) >= 0) {
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return cis.getChecksum().getValue();
    }

    public static void copy(ReadableByteChannel inChannel, WritableByteChannel outChannel) {
        StreamUtil.copy(inChannel, outChannel, true);
    }

    public static void copy(ReadableByteChannel inChannel, WritableByteChannel outChannel, boolean closeChannels) {
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        try {
            while (inChannel.read(buffer) != -1) {
                buffer.flip();
                outChannel.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                outChannel.write(buffer);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            buffer.clear();
            buffer = null;
            try {
                if (inChannel != null && closeChannels) {
                    inChannel.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
            try {
                if (outChannel != null && !(outChannel instanceof FileCachedInputStream) && closeChannels) {
                    outChannel.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
        }
    }

    public static void copy(InputStream in, File outputFile) {
        try {
            if (!outputFile.exists()) {
                Util.createDirectories(outputFile.getAbsolutePath());
                outputFile.createNewFile();
            }
            Files.copy(in, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public static void copy(InputStream is, String outputPath) {
        try {
            Files.copy(is, Paths.get(outputPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, OutputStream outputStream) {
        ReadableByteChannel inChannel = null;
        WritableByteChannel outChannel = null;
        try {
            inChannel = Channels.newChannel(is);
            outChannel = Channels.newChannel(outputStream);
            StreamUtil.copy(inChannel, outChannel);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
        }
    }

    public static void copy(File in, File out) {
        try {
            Files.copy(in.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public static void copy(String fromPath, String toPath, boolean move) {
        try {
            Util.createDirectories(toPath);
            Files.copy(Paths.get(fromPath, new String[0]), Paths.get(toPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public static FileCachedInputStream createResettableStream(InputStream is, int bufferSize) throws IOException {
        FileCachedInputStream ifcis;
        try {
            ifcis = new FileCachedInputStream(bufferSize);
            StreamUtil.copy(Channels.newChannel(is), ifcis);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error copying inputstream to FileCachedInputStream", e);
        }
        finally {
            is.close();
        }
        ifcis.mark(Integer.MAX_VALUE);
        return ifcis;
    }

    public boolean isCompressed(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }
}

