/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;

public class OpenXMLEncoder
implements IEncoder {
    private String lineBreak;

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.lineBreak = lineBreak;
    }

    @Override
    public void reset() {
    }

    @Override
    public String encode(String text, EncoderContext context) {
        if (text == null) {
            return "";
        }
        StringBuffer sbTmp = new StringBuffer(text.length());
        block6: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    sbTmp.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sbTmp.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sbTmp.append("&amp;");
                    continue block6;
                }
                case '\n': {
                    sbTmp.append(this.lineBreak);
                    continue block6;
                }
                default: {
                    if (ch > '\u007f') {
                        if (Character.isHighSurrogate(ch)) {
                            int cp = text.codePointAt(i++);
                            String tmp = new String(Character.toChars(cp));
                            sbTmp.append(tmp);
                            continue block6;
                        }
                        sbTmp.append(String.valueOf(ch));
                        continue block6;
                    }
                    sbTmp.append(ch);
                }
            }
        }
        return sbTmp.toString();
    }

    @Override
    public String encode(char value, EncoderContext context) {
        switch (value) {
            case '<': {
                return "&lt;";
            }
            case '&': {
                return "&amp;";
            }
            case '>': {
                return "&gt;";
            }
            case '\n': {
                return this.lineBreak;
            }
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        switch (value) {
            case 60: {
                return "&lt;";
            }
            case 38: {
                return "&amp;";
            }
            case 62: {
                return "&lt;";
            }
            case 10: {
                return this.lineBreak;
            }
        }
        if (value > 127) {
            if (Character.isSupplementaryCodePoint(value)) {
                String tmp = new String(Character.toChars(value));
                return tmp;
            }
            return String.valueOf((char)value);
        }
        return String.valueOf((char)value);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return null;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public String getEncoding() {
        return "";
    }
}

