/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.InvalidPositionException;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;

public class Segments
implements ISegments {
    private AlignmentStatus alignmentStatus = AlignmentStatus.ALIGNED;
    private TextContainer parent;
    private List<TextPart> parts;

    public Segments() {
    }

    public Segments(TextContainer parent) {
        this.parent = parent;
    }

    public void setParts(List<TextPart> parts) {
        this.parts = parts;
    }

    @Override
    public Iterator<Segment> iterator() {
        return new Iterator<Segment>(){
            int current = this.foundNext(-1);

            private int foundNext(int start) {
                for (int i = start + 1; i < Segments.this.parts.size(); ++i) {
                    if (!((TextPart)Segments.this.parts.get(i)).isSegment()) continue;
                    return i;
                }
                return -1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public Segment next() {
                if (this.current == -1) {
                    throw new NoSuchElementException("No more content parts.");
                }
                int n = this.current;
                this.current = this.foundNext(this.current);
                return (Segment)Segments.this.parts.get(n);
            }

            @Override
            public boolean hasNext() {
                return this.current != -1;
            }
        };
    }

    @Override
    public List<Segment> asList() {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (TextPart part : this.parts) {
            if (!part.isSegment()) continue;
            segments.add((Segment)part);
        }
        return segments;
    }

    @Override
    public void swap(int segIndex1, int segIndex2) {
        int partIndex1 = this.getPartIndex(segIndex1);
        int partIndex2 = this.getPartIndex(segIndex2);
        if (partIndex1 == -1 || partIndex2 == -1) {
            return;
        }
        TextPart tmp = this.parts.get(partIndex1);
        this.parts.set(partIndex1, this.parts.get(partIndex2));
        this.parts.set(partIndex2, tmp);
    }

    @Override
    public void append(Segment segment, boolean collapseIfPreviousEmpty) {
        this.append(segment, null, collapseIfPreviousEmpty);
    }

    @Override
    public void append(Segment segment) {
        this.append(segment, true);
    }

    @Override
    public void append(Segment segment, String textBefore, boolean collapseIfPreviousEmpty) {
        if (!Util.isEmpty(textBefore)) {
            if (this.parts.get(this.parts.size() - 1).getContent().isEmpty() && !this.parts.get(this.parts.size() - 1).isSegment()) {
                this.parts.set(this.parts.size() - 1, new TextPart(textBefore));
            } else {
                this.parts.add(new TextPart(textBefore));
            }
        }
        if (collapseIfPreviousEmpty) {
            if (this.parts.get(this.parts.size() - 1).getContent().isEmpty() && this.parts.get(this.parts.size() - 1).isSegment()) {
                this.parts.set(this.parts.size() - 1, segment);
            } else {
                this.parts.add(segment);
            }
        } else {
            this.parts.add(segment);
        }
        this.validateSegmentId(segment);
        this.parent.setHasBeenSegmentedFlag(true);
    }

    @Override
    public void append(Segment segment, String textBefore) {
        this.append(segment, textBefore, true);
    }

    @Override
    public void append(TextFragment fragment, boolean collapseIfPreviousEmpty) {
        this.append(new Segment(null, fragment), collapseIfPreviousEmpty);
    }

    @Override
    public void append(TextFragment fragment) {
        this.append(fragment, true);
    }

    @Override
    public void set(int index, Segment seg) {
        int n = this.getPartIndex(index);
        if (n < -1) {
            throw new IndexOutOfBoundsException("Invalid segment index: " + index);
        }
        this.parts.set(n, seg);
        this.validateSegmentId(seg);
    }

    @Override
    public void insert(int index, Segment seg) {
        if (index == this.count()) {
            this.append(seg, true);
            return;
        }
        int n = this.getPartIndex(index);
        if (n < -1) {
            throw new IndexOutOfBoundsException("Invalid segment index: " + index);
        }
        this.parts.add(n, seg);
        this.validateSegmentId(seg);
    }

    @Override
    public int create(List<Range> ranges) {
        return this.create(ranges, false);
    }

    @Override
    public int create(List<Range> ranges, boolean allowEmptySegments) {
        if (ranges == null || ranges.isEmpty()) {
            return 0;
        }
        TextFragment holder = this.parts.size() == 1 ? this.parts.get(0).getContent() : this.createJoinedContent(null);
        this.parts.clear();
        int start = 0;
        int id = 0;
        for (Range range : ranges) {
            if (range.end == -1) {
                range.end = holder.text.length();
            }
            if (range.end < range.start) {
                throw new InvalidPositionException(String.format("Invalid segment boundaries: start=%d, end=%d.", range.start, range.end));
            }
            if (start > range.start) {
                throw new InvalidPositionException("Invalid range order.");
            }
            if (range.end == range.start && !allowEmptySegments) continue;
            if (start < range.start) {
                this.parts.add(new TextPart(holder.subSequence(start, range.start)));
            }
            Segment seg = new Segment(range.id == null ? String.valueOf(id++) : range.id, holder.subSequence(range.start, range.end));
            this.parts.add(seg);
            this.validateSegmentId(seg);
            start = range.end;
            this.parent.setHasBeenSegmentedFlag(true);
        }
        if (start < holder.text.length()) {
            if (start == 0) {
                if (this.parts.size() > 0) {
                    this.parts.add(new TextPart(holder.subSequence(start, -1)));
                } else {
                    this.parts.add(new Segment(String.valueOf(id), holder));
                }
            } else {
                this.parts.add(new TextPart(holder.subSequence(start, -1)));
            }
        }
        return this.parts.size();
    }

    @Override
    public int create(int start, int end) {
        ArrayList<Range> range = new ArrayList<Range>();
        range.add(new Range(start, end));
        return this.create(range);
    }

    @Override
    public int count() {
        int count = 0;
        for (TextPart part : this.parts) {
            if (!part.isSegment()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public TextFragment getFirstContent() {
        for (TextPart part : this.parts) {
            if (!part.isSegment()) continue;
            return part.getContent();
        }
        return null;
    }

    @Override
    public TextFragment getLastContent() {
        for (int i = this.parts.size() - 1; i >= 0; --i) {
            if (!this.parts.get(i).isSegment()) continue;
            return this.parts.get(i).getContent();
        }
        return null;
    }

    @Override
    public Segment getLast() {
        for (int i = this.parts.size() - 1; i >= 0; --i) {
            if (!this.parts.get(i).isSegment()) continue;
            return (Segment)this.parts.get(i);
        }
        return null;
    }

    @Override
    public Segment get(String id) {
        for (TextPart part : this.parts) {
            if (!part.isSegment() || !((Segment)part).id.equals(id)) continue;
            return (Segment)part;
        }
        return null;
    }

    @Override
    public Segment get(int index) {
        int tmp = -1;
        for (TextPart part : this.parts) {
            if (!part.isSegment() || ++tmp != index) continue;
            return (Segment)part;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + ++tmp);
    }

    @Override
    public void joinAll() {
        this.joinAll(null);
    }

    @Override
    public void joinAll(List<Range> ranges) {
        this.parent.setContent(this.createJoinedContent(ranges));
    }

    @Override
    public List<Range> getRanges() {
        ArrayList<Range> ranges = new ArrayList<Range>();
        this.createJoinedContent(ranges);
        return ranges;
    }

    @Override
    public int joinWithNext(int segmentIndex) {
        if (this.parts.size() == 1) {
            return 0;
        }
        int start = this.getPartIndex(segmentIndex);
        if (start == -1) {
            return 0;
        }
        int end = -1;
        for (int i = start + 1; i < this.parts.size(); ++i) {
            if (!this.parts.get(i).isSegment()) continue;
            end = i;
            break;
        }
        if (end == -1) {
            return 0;
        }
        TextFragment tf = this.parts.get(start).getContent();
        int count = end - start;
        for (int i = 0; i < count; ++i) {
            tf.append(this.parts.get(start + 1).getContent());
            this.parts.remove(start + 1);
        }
        return count;
    }

    @Override
    public int getPartIndex(int segIndex) {
        int n = -1;
        for (int i = 0; i < this.parts.size(); ++i) {
            if (!this.parts.get(i).isSegment() || ++n != segIndex) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String segId) {
        int n = 0;
        for (int i = 0; i < this.parts.size(); ++i) {
            if (!this.parts.get(i).isSegment()) continue;
            if (segId.equals(((Segment)this.parts.get((int)i)).id)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public AlignmentStatus getAlignmentStatus() {
        return this.alignmentStatus;
    }

    @Override
    public void setAlignmentStatus(AlignmentStatus alignmentStatus) {
        this.alignmentStatus = alignmentStatus;
    }

    public void validateSegmentId(Segment seg) {
        if (!Util.isEmpty(seg.id)) {
            boolean duplicate = false;
            for (TextPart tmp : this.parts) {
                if (!tmp.isSegment() || seg == tmp || !seg.id.equals(((Segment)tmp).id)) continue;
                duplicate = true;
                break;
            }
            if (!duplicate) {
                return;
            }
        }
        int value = 0;
        for (TextPart tmp : this.parts) {
            if (tmp == seg || !tmp.isSegment() || !Character.isDigit(((Segment)tmp).id.charAt(0))) continue;
            try {
                int val = Integer.parseInt(((Segment)tmp).id);
                if (value > val) continue;
                value = val + 1;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        seg.id = String.valueOf(value);
    }

    private TextFragment createJoinedContent(List<Range> ranges) {
        if (ranges != null) {
            ranges.clear();
        }
        int start = 0;
        TextFragment tf = new TextFragment();
        for (TextPart part : this.parts) {
            if (ranges != null && part.isSegment()) {
                ranges.add(new Range(start, start + part.text.text.length(), ((Segment)part).id));
            }
            start += part.text.text.length();
            tf.append(part.getContent());
        }
        return tf;
    }

    public TextContainer getParent() {
        return this.parent;
    }

    public List<TextPart> getParts() {
        return this.parts;
    }
}

