/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.google.FragmentQueryResultBuilder;
import net.sf.okapi.connectors.google.GoogleMTAPI;
import net.sf.okapi.connectors.google.GoogleMTAPIImpl;
import net.sf.okapi.connectors.google.GoogleMTErrorException;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;
import net.sf.okapi.connectors.google.GoogleQueryBuilder;
import net.sf.okapi.connectors.google.QueryResultBuilder;
import net.sf.okapi.connectors.google.TextQueryResultBuilder;
import net.sf.okapi.connectors.google.TranslationResponse;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleMTv2Connector
extends BaseConnector {
    private static final String BASE_URL = "https://translation.googleapis.com/language/translate/v2";
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private GoogleMTv2Parameters params = new GoogleMTv2Parameters();
    private QueryUtil util = new QueryUtil();
    private GoogleMTAPI api;

    public GoogleMTv2Connector() {
        this.api = new GoogleMTAPIImpl(BASE_URL, this.params);
    }

    public GoogleMTv2Connector(GoogleMTAPI api) {
        this.api = api;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (GoogleMTv2Parameters)params;
    }

    @Override
    public GoogleMTv2Parameters getParameters() {
        return this.params;
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "Google-MTv2";
    }

    @Override
    public String getSettingsDisplay() {
        return "Server: https://translation.googleapis.com/language/translate/v2";
    }

    @Override
    public void open() {
    }

    @Override
    public int query(String plainText) {
        return this._query(plainText, plainText, new TextQueryResultBuilder(this.params, this.getName(), this.getWeight()));
    }

    @Override
    public int query(TextFragment frag) {
        return this._query(this.util.toCodedHTML(frag), frag, new FragmentQueryResultBuilder(this.params, this.getName(), this.getWeight()));
    }

    private void retryInterval(int retryCount, String operation) {
        this.LOG.info("{} - retry {} (waiting {} ms", operation, retryCount, this.params.getRetryIntervalMs());
        try {
            Thread.sleep(this.params.getRetryIntervalMs());
        }
        catch (InterruptedException e) {
            throw new OkapiException("Interrupted while trying to contact Google MT");
        }
    }

    protected <T> int _query(String queryText, T originalText, QueryResultBuilder<T> qrBuilder) {
        this.current = -1;
        if (queryText.isEmpty()) {
            return 0;
        }
        if (Util.isEmpty(this.params.getApiKey())) {
            throw new OkapiException("You must have a Google API Key to use this connector.");
        }
        ArrayList<QueryResult> queryResults = new ArrayList<QueryResult>();
        GoogleQueryBuilder<T> qb = new GoogleQueryBuilder<T>(BASE_URL, this.getParameters(), this.srcCode, this.trgCode);
        qb.addQuery(queryText, originalText);
        List<TranslationResponse> responses = this.executeQuery(qb, qrBuilder);
        if (responses != null) {
            queryResults.addAll(qrBuilder.convertResponses(responses, originalText));
        } else {
            this.LOG.error("Received no results for query {}", (Object)qb.getQuery());
            queryResults.add(qrBuilder.createDummyResponse(originalText));
        }
        if (queryResults.size() > 0) {
            this.current = 0;
            this.result = (QueryResult)queryResults.iterator().next();
            return 1;
        }
        throw new OkapiException("Could not retrieve results from Google after " + this.params.getRetryCount() + " attempts.");
    }

    @Override
    public List<List<QueryResult>> batchQueryText(List<String> plainTexts) {
        return this._batchQuery(plainTexts, plainTexts, new TextQueryResultBuilder(this.params, this.getName(), this.getWeight()));
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        return this._batchQuery(this.util.toCodedHTML(fragments), fragments, new FragmentQueryResultBuilder(this.params, this.getName(), this.getWeight()));
    }

    protected <T> List<List<QueryResult>> _batchQuery(List<String> texts, List<T> originalTexts, QueryResultBuilder<T> qrBuilder) {
        if (Util.isEmpty(this.params.getApiKey())) {
            throw new OkapiException("You must have a Google API Key to use this connector.");
        }
        GoogleQueryBuilder<T> qb = new GoogleQueryBuilder<T>(BASE_URL, this.params, this.srcCode, this.trgCode);
        this.current = -1;
        ArrayList<List<QueryResult>> queryResults = new ArrayList<List<QueryResult>>(texts.size());
        for (int i = 0; i < texts.size(); ++i) {
            String sourceText = texts.get(i);
            T originalText = originalTexts.get(i);
            if (qb.hasCapacity(sourceText)) {
                qb.addQuery(sourceText, originalText);
                continue;
            }
            queryResults.addAll(this.flushQuery(qb, qrBuilder));
            if (qb.hasCapacity(sourceText)) {
                qb.addQuery(sourceText, originalText);
                continue;
            }
            TranslationResponse response = this.executeSingleSegmentQuery(qb, sourceText);
            if (response != null) {
                queryResults.add(qrBuilder.convertResponses(Collections.singletonList(response), originalText));
                continue;
            }
            this.LOG.error("Received no results for query {}", (Object)qb.getQuery());
            queryResults.add(Collections.singletonList(qrBuilder.createDummyResponse(originalText)));
        }
        queryResults.addAll(this.flushQuery(qb, qrBuilder));
        return queryResults;
    }

    protected <T> List<List<QueryResult>> flushQuery(GoogleQueryBuilder<T> qb, QueryResultBuilder<T> qrBuilder) {
        ArrayList<List<QueryResult>> queryResults = new ArrayList<List<QueryResult>>();
        if (qb.getSourceCount() > 0) {
            this.LOG.debug("Flushing batch query of length {}, '{}'", (Object)qb.getQuery().length(), (Object)qb.getQuery());
            List<TranslationResponse> batchResponses = this.executeQuery(qb, qrBuilder);
            if (batchResponses != null) {
                for (int j = 0; j < batchResponses.size(); ++j) {
                    queryResults.add(qrBuilder.convertResponses(Collections.singletonList(batchResponses.get(j)), qb.getSources().get(j)));
                }
            } else {
                this.LOG.error("Received no results for query {}", (Object)qb.getQuery());
                for (T source : qb.getSources()) {
                    queryResults.add(Collections.singletonList(qrBuilder.createDummyResponse(source)));
                }
            }
            qb.reset();
        }
        return queryResults;
    }

    protected <T> TranslationResponse executeSingleSegmentQuery(GoogleQueryBuilder<T> qb, String sourceText) {
        try {
            for (int tries = 0; tries < this.params.getRetryCount(); ++tries) {
                try {
                    return this.api.translateSingleSegment(qb, sourceText);
                }
                catch (GoogleMTErrorException e) {
                    this.LOG.error("Error {} - {} for query {}", e.getCode(), e.getMessage(), e.getQuery());
                    this.retryInterval(tries + 1, "_batchQuery");
                    continue;
                }
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error querying the MT server: " + e.getMessage(), e);
        }
        return null;
    }

    protected <T> List<TranslationResponse> executeQuery(GoogleQueryBuilder<T> qb, QueryResultBuilder<T> qrBuilder) {
        try {
            for (int tries = 0; tries < this.params.getRetryCount(); ++tries) {
                try {
                    return this.api.translate(qb);
                }
                catch (GoogleMTErrorException e) {
                    this.LOG.error("Error {} - {} for query {}", e.getCode(), e.getMessage(), e.getQuery());
                    this.retryInterval(tries + 1, "_batchQuery");
                    continue;
                }
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error querying the MT server: " + e.getMessage(), e);
        }
        return null;
    }

    public List<LocaleId> getSupportedLanguages() {
        try {
            for (int tries = 0; tries < this.params.getRetryCount(); ++tries) {
                List<String> codes = this.api.getLanguages();
                if (codes != null) {
                    ArrayList<LocaleId> locales = new ArrayList<LocaleId>();
                    for (String code : codes) {
                        locales.add(this.convertGoogleLanguageCode(code));
                    }
                    return locales;
                }
                this.retryInterval(tries + 1, "getSupportedLanguages");
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error querying the MT server: " + e.getMessage(), e);
        }
        throw new OkapiException("Could not retrieve language list from Google after " + this.params.getRetryCount() + " attempts.");
    }

    protected LocaleId convertGoogleLanguageCode(String lang) {
        return LocaleId.fromBCP47(lang);
    }

    @Override
    public void leverage(ITextUnit tu) {
        this.leverageUsingBatchQuery(tu);
    }

    @Override
    public void batchLeverage(List<ITextUnit> tuList) {
        this.batchLeverageUsingBatchQuery(tuList);
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String code = locale.toBCP47();
        if (!code.startsWith("zh") && code.length() > 2) {
            code = code.substring(0, 2);
        }
        return code;
    }
}

